/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.lookup.hash;

import java.io.File;
import java.io.IOException;
import org.apache.paimon.io.cache.CacheManager;
import org.apache.paimon.lookup.LookupStoreFactory;
import org.apache.paimon.lookup.hash.HashLookupStoreReader;
import org.apache.paimon.lookup.hash.HashLookupStoreWriter;

public class HashLookupStoreFactory
implements LookupStoreFactory {
    private final CacheManager cacheManager;
    private final double loadFactor;

    public HashLookupStoreFactory(CacheManager cacheManager, double loadFactor) {
        this.cacheManager = cacheManager;
        this.loadFactor = loadFactor;
    }

    @Override
    public HashLookupStoreWriter createWriter(File file) throws IOException {
        return new HashLookupStoreWriter(this.loadFactor, file);
    }

    @Override
    public HashLookupStoreReader createReader(File file) throws IOException {
        return new HashLookupStoreReader(this.cacheManager, file);
    }
}

