/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.utils;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.flink.FlinkRowData;
import org.apache.paimon.flink.LogicalTypeConversion;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.SerBiFunction;

public class ProjectToRowDataFunction
implements SerBiFunction<RowData, BinaryRow, RowData> {
    private final RowData.FieldGetter[] fieldGetters;
    private final Map<Integer, Integer> projectMapping;
    private final RowData.FieldGetter[] projectGetters;

    public ProjectToRowDataFunction(RowType rowType, List<String> projectFields) {
        LogicalType[] types = LogicalTypeConversion.toLogicalType(rowType).getChildren().toArray(new LogicalType[0]);
        this.fieldGetters = (RowData.FieldGetter[])IntStream.range(0, types.length).mapToObj(i -> RowData.createFieldGetter((LogicalType)types[i], (int)i)).toArray(RowData.FieldGetter[]::new);
        List<String> fieldNames = rowType.getFieldNames();
        this.projectMapping = projectFields.stream().collect(Collectors.toMap(fieldNames::indexOf, projectFields::indexOf));
        this.projectGetters = (RowData.FieldGetter[])projectFields.stream().map(field -> RowData.createFieldGetter((LogicalType)types[rowType.getFieldIndex((String)field)], (int)projectFields.indexOf(field))).toArray(RowData.FieldGetter[]::new);
    }

    @Override
    public RowData apply(RowData input, BinaryRow project) {
        GenericRowData newRow = new GenericRowData(this.fieldGetters.length);
        FlinkRowData partRow = new FlinkRowData(project);
        for (int i = 0; i < this.fieldGetters.length; ++i) {
            Object field = this.projectMapping.containsKey(i) ? this.projectGetters[this.projectMapping.get(i)].getFieldOrNull((RowData)partRow) : this.fieldGetters[i].getFieldOrNull(input);
            newRow.setField(i, field);
        }
        return newRow;
    }
}

