/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.source.metrics;

import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.metrics.MetricGroup;

public class FileStoreSourceReaderMetrics {
    private long latestFileCreationTime = -1L;
    private long lastSplitUpdateTime = -1L;
    public static final long UNDEFINED = -1L;

    public FileStoreSourceReaderMetrics(MetricGroup sourceReaderMetricGroup) {
        sourceReaderMetricGroup.gauge("currentFetchEventTimeLag", this::getFetchTimeLag);
    }

    public void recordSnapshotUpdate(long fileCreationTime) {
        this.latestFileCreationTime = fileCreationTime;
        this.lastSplitUpdateTime = System.currentTimeMillis();
    }

    @VisibleForTesting
    long getFetchTimeLag() {
        if (this.latestFileCreationTime != -1L) {
            return this.lastSplitUpdateTime - this.latestFileCreationTime;
        }
        return -1L;
    }

    @VisibleForTesting
    long getLatestFileCreationTime() {
        return this.latestFileCreationTime;
    }

    @VisibleForTesting
    long getLastSplitUpdateTime() {
        return this.lastSplitUpdateTime;
    }
}

