/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.source;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.api.connector.source.SplitEnumerator;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.api.connector.source.SplitsAssignment;
import org.apache.paimon.Snapshot;
import org.apache.paimon.flink.source.FileStoreSourceSplit;
import org.apache.paimon.flink.source.PendingSplitsCheckpoint;
import org.apache.paimon.flink.source.assigners.SplitAssigner;

public class StaticFileStoreSplitEnumerator
implements SplitEnumerator<FileStoreSourceSplit, PendingSplitsCheckpoint> {
    private final SplitEnumeratorContext<FileStoreSourceSplit> context;
    @Nullable
    private final Snapshot snapshot;
    private final SplitAssigner splitAssigner;

    public StaticFileStoreSplitEnumerator(SplitEnumeratorContext<FileStoreSourceSplit> context, @Nullable Snapshot snapshot, SplitAssigner splitAssigner) {
        this.context = context;
        this.snapshot = snapshot;
        this.splitAssigner = splitAssigner;
    }

    public void start() {
    }

    public void handleSplitRequest(int subtask, @Nullable String hostname) {
        if (!this.context.registeredReaders().containsKey(subtask)) {
            return;
        }
        List<FileStoreSourceSplit> assignment = this.splitAssigner.getNext(subtask, hostname);
        if (assignment.size() > 0) {
            this.context.assignSplits(new SplitsAssignment(Collections.singletonMap(subtask, assignment)));
        } else {
            this.context.signalNoMoreSplits(subtask);
        }
    }

    public void addSplitsBack(List<FileStoreSourceSplit> backSplits, int subtaskId) {
        this.splitAssigner.addSplitsBack(subtaskId, backSplits);
    }

    public void addReader(int subtaskId) {
    }

    public PendingSplitsCheckpoint snapshotState(long checkpointId) {
        return new PendingSplitsCheckpoint(this.splitAssigner.remainingSplits(), this.snapshot == null ? null : Long.valueOf(this.snapshot.id()));
    }

    public void close() {
    }

    @Nullable
    public Snapshot snapshot() {
        return this.snapshot;
    }
}

