/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.source;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.flink.FlinkConnectorOptions;
import org.apache.paimon.flink.LogicalTypeConversion;
import org.apache.paimon.flink.source.ContinuousFileStoreSource;
import org.apache.paimon.flink.source.StaticFileStoreSource;
import org.apache.paimon.options.Options;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateBuilder;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.source.ReadBuilder;
import org.apache.paimon.table.system.BucketsTable;
import org.apache.paimon.types.RowType;

public class CompactorSourceBuilder {
    private final String tableIdentifier;
    private final FileStoreTable table;
    private boolean isContinuous = false;
    private StreamExecutionEnvironment env;
    @Nullable
    private List<Map<String, String>> specifiedPartitions = null;

    public CompactorSourceBuilder(String tableIdentifier, FileStoreTable table) {
        this.tableIdentifier = tableIdentifier;
        this.table = table;
    }

    public CompactorSourceBuilder withContinuousMode(boolean isContinuous) {
        this.isContinuous = isContinuous;
        return this;
    }

    public CompactorSourceBuilder withEnv(StreamExecutionEnvironment env) {
        this.env = env;
        return this;
    }

    public CompactorSourceBuilder withPartition(Map<String, String> partition) {
        return this.withPartitions(Collections.singletonList(partition));
    }

    public CompactorSourceBuilder withPartitions(List<Map<String, String>> partitions) {
        this.specifiedPartitions = partitions;
        return this;
    }

    private Source<RowData, ?, ?> buildSource(BucketsTable bucketsTable) {
        Predicate partitionPredicate = null;
        if (this.specifiedPartitions != null) {
            partitionPredicate = PredicateBuilder.or((Predicate[])this.specifiedPartitions.stream().map(p -> PredicateBuilder.partition(p, this.table.rowType())).toArray(Predicate[]::new));
        }
        if (this.isContinuous) {
            bucketsTable = ((BucketsTable)bucketsTable).copy((Map)this.streamingCompactOptions());
            return new ContinuousFileStoreSource(bucketsTable.newReadBuilder().withFilter(partitionPredicate), ((BucketsTable)bucketsTable).options(), null);
        }
        bucketsTable = ((BucketsTable)bucketsTable).copy((Map)this.batchCompactOptions());
        ReadBuilder readBuilder = bucketsTable.newReadBuilder().withFilter(partitionPredicate);
        Options options = ((BucketsTable)bucketsTable).coreOptions().toConfiguration();
        return new StaticFileStoreSource(readBuilder, null, options.get(FlinkConnectorOptions.SCAN_SPLIT_ENUMERATOR_BATCH_SIZE), options.get(FlinkConnectorOptions.SCAN_SPLIT_ENUMERATOR_ASSIGN_MODE));
    }

    public DataStreamSource<RowData> build() {
        if (this.env == null) {
            throw new IllegalArgumentException("StreamExecutionEnvironment should not be null.");
        }
        BucketsTable bucketsTable = new BucketsTable(this.table, this.isContinuous);
        RowType produceType = bucketsTable.rowType();
        return this.env.fromSource(this.buildSource(bucketsTable), WatermarkStrategy.noWatermarks(), this.tableIdentifier + "-compact-source", (TypeInformation)InternalTypeInfo.of((org.apache.flink.table.types.logical.RowType)LogicalTypeConversion.toLogicalType(produceType)));
    }

    private Map<String, String> streamingCompactOptions() {
        return new HashMap<String, String>(){
            {
                this.put(CoreOptions.STREAMING_COMPACT.key(), CoreOptions.StreamingCompactionType.NORMAL.getValue());
                this.put(CoreOptions.SCAN_BOUNDED_WATERMARK.key(), null);
            }
        };
    }

    private Map<String, String> batchCompactOptions() {
        return new HashMap<String, String>(){
            {
                this.put(CoreOptions.SCAN_TIMESTAMP_MILLIS.key(), null);
                this.put(CoreOptions.SCAN_SNAPSHOT_ID.key(), null);
                this.put(CoreOptions.SCAN_MODE.key(), CoreOptions.StartupMode.LATEST_FULL.toString());
            }
        };
    }
}

