/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink.index;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.table.data.RowData;
import org.apache.paimon.codegen.CodeGenUtils;
import org.apache.paimon.codegen.Projection;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.flink.FlinkRowWrapper;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.sink.PartitionKeyExtractor;
import org.apache.paimon.types.RowType;

public class KeyPartPartitionKeyExtractor
implements PartitionKeyExtractor<RowData> {
    private final Projection partitionProjection;
    private final Projection keyProjection;

    public KeyPartPartitionKeyExtractor(TableSchema schema) {
        List<String> primaryKeys = schema.primaryKeys();
        List<String> partitionKeys = schema.partitionKeys();
        RowType keyPartType = schema.projectedLogicalRowType(Stream.concat(primaryKeys.stream(), partitionKeys.stream()).collect(Collectors.toList()));
        this.partitionProjection = CodeGenUtils.newProjection(keyPartType, partitionKeys);
        this.keyProjection = CodeGenUtils.newProjection(keyPartType, primaryKeys);
    }

    @Override
    public BinaryRow partition(RowData record) {
        return this.partitionProjection.apply(new FlinkRowWrapper(record));
    }

    @Override
    public BinaryRow trimmedPrimaryKey(RowData record) {
        return this.keyProjection.apply(new FlinkRowWrapper(record));
    }
}

