/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink.index;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.typeutils.RowDataSerializer;
import org.apache.paimon.flink.FlinkRowData;
import org.apache.paimon.flink.LogicalTypeConversion;
import org.apache.paimon.flink.sink.Committable;
import org.apache.paimon.flink.sink.DynamicBucketRowWriteOperator;
import org.apache.paimon.flink.sink.FlinkStreamPartitioner;
import org.apache.paimon.flink.sink.FlinkWriteSink;
import org.apache.paimon.flink.sink.RowWithBucketChannelComputer;
import org.apache.paimon.flink.sink.StoreSinkWrite;
import org.apache.paimon.flink.sink.index.GlobalIndexAssignerOperator;
import org.apache.paimon.flink.sink.index.IndexBootstrap;
import org.apache.paimon.flink.sink.index.IndexBootstrapOperator;
import org.apache.paimon.flink.sink.index.KeyPartOrRow;
import org.apache.paimon.flink.sink.index.KeyPartRowChannelComputer;
import org.apache.paimon.flink.sink.index.KeyWithRowSerializer;
import org.apache.paimon.flink.utils.InternalTypeInfo;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.types.RowType;

public class GlobalDynamicBucketSink
extends FlinkWriteSink<Tuple2<RowData, Integer>> {
    private static final long serialVersionUID = 1L;

    public GlobalDynamicBucketSink(FileStoreTable table, @Nullable Map<String, String> overwritePartition) {
        super(table, overwritePartition);
    }

    @Override
    protected OneInputStreamOperator<Tuple2<RowData, Integer>, Committable> createWriteOperator(StoreSinkWrite.Provider writeProvider, String commitUser) {
        return new DynamicBucketRowWriteOperator(this.table, writeProvider, commitUser);
    }

    public DataStreamSink<?> build(DataStream<RowData> input, @Nullable Integer parallelism) {
        String initialCommitUser = UUID.randomUUID().toString();
        TableSchema schema = this.table.schema();
        RowType rowType = schema.logicalRowType();
        List<String> primaryKeys = schema.primaryKeys();
        RowDataSerializer rowSerializer = new RowDataSerializer(LogicalTypeConversion.toLogicalType(rowType));
        RowType bootstrapType = IndexBootstrap.bootstrapType(schema);
        RowDataSerializer bootstrapSerializer = new RowDataSerializer(LogicalTypeConversion.toLogicalType(bootstrapType));
        SingleOutputStreamOperator bootstraped = input.transform("INDEX_BOOTSTRAP", new InternalTypeInfo(new KeyWithRowSerializer(bootstrapSerializer, rowSerializer)), new IndexBootstrapOperator(new IndexBootstrap(this.table), FlinkRowData::new)).setParallelism(input.getParallelism());
        Integer assignerParallelism = this.table.coreOptions().dynamicBucketAssignerParallelism();
        if (assignerParallelism == null) {
            assignerParallelism = parallelism;
        }
        KeyPartRowChannelComputer channelComputer = new KeyPartRowChannelComputer(rowType, bootstrapType, primaryKeys);
        DataStream<Tuple2<KeyPartOrRow, RowData>> partitionByKeyHash = FlinkStreamPartitioner.partition(bootstraped, channelComputer, assignerParallelism);
        TupleTypeInfo rowWithBucketType = new TupleTypeInfo(new TypeInformation[]{input.getType(), BasicTypeInfo.INT_TYPE_INFO});
        SingleOutputStreamOperator bucketAssigned = partitionByKeyHash.transform("dynamic-bucket-assigner", (TypeInformation)rowWithBucketType, GlobalIndexAssignerOperator.forRowData(this.table)).setParallelism(partitionByKeyHash.getParallelism());
        DataStream<Tuple2<RowData, Integer>> partitionByBucket = FlinkStreamPartitioner.partition(bucketAssigned, new RowWithBucketChannelComputer(schema), parallelism);
        return this.sinkFrom(partitionByBucket, initialCommitUser);
    }
}

