/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink;

import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.table.data.RowData;
import org.apache.paimon.flink.sink.ChannelComputer;
import org.apache.paimon.flink.sink.RowDataPartitionKeyExtractor;
import org.apache.paimon.schema.TableSchema;

public class RowWithBucketChannelComputer
implements ChannelComputer<Tuple2<RowData, Integer>> {
    private static final long serialVersionUID = 1L;
    private final TableSchema schema;
    private transient int numChannels;
    private transient RowDataPartitionKeyExtractor extractor;

    public RowWithBucketChannelComputer(TableSchema schema) {
        this.schema = schema;
    }

    @Override
    public void setup(int numChannels) {
        this.numChannels = numChannels;
        this.extractor = new RowDataPartitionKeyExtractor(this.schema);
    }

    @Override
    public int channel(Tuple2<RowData, Integer> record) {
        return ChannelComputer.select(this.extractor.partition((RowData)record.f0), (Integer)record.f1, this.numChannels);
    }

    public String toString() {
        return "shuffle by partition & bucket";
    }
}

