/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.lookup;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.paimon.data.serializer.Serializer;
import org.apache.paimon.flink.lookup.RocksDBState;
import org.apache.paimon.utils.Preconditions;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;

public class RocksDBValueState<K, V>
extends RocksDBState<K, V, RocksDBState.Reference> {
    public RocksDBValueState(RocksDB db, ColumnFamilyHandle columnFamily, Serializer<K> keySerializer, Serializer<V> valueSerializer, long lruCacheSize) {
        super(db, columnFamily, keySerializer, valueSerializer, lruCacheSize);
    }

    @Nullable
    public V get(K key) throws IOException {
        try {
            RocksDBState.Reference valueRef = this.get(this.wrap(this.serializeKey(key)));
            return valueRef.isPresent() ? (V)this.deserializeValue(valueRef.bytes) : null;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private RocksDBState.Reference get(RocksDBState.ByteArray keyBytes) throws RocksDBException {
        RocksDBState.Reference valueRef = (RocksDBState.Reference)this.cache.getIfPresent(keyBytes);
        if (valueRef == null) {
            valueRef = this.ref(this.db.get(this.columnFamily, keyBytes.bytes));
            this.cache.put(keyBytes, valueRef);
        }
        return valueRef;
    }

    public void put(K key, V value) throws IOException {
        Preconditions.checkArgument(value != null);
        try {
            byte[] keyBytes = this.serializeKey(key);
            byte[] valueBytes = this.serializeValue(value);
            this.db.put(this.columnFamily, this.writeOptions, keyBytes, valueBytes);
            this.cache.put(this.wrap(keyBytes), this.ref(valueBytes));
        }
        catch (RocksDBException e) {
            throw new IOException(e);
        }
    }

    public void delete(K key) throws IOException {
        try {
            byte[] keyBytes = this.serializeKey(key);
            RocksDBState.ByteArray keyByteArray = this.wrap(keyBytes);
            if (this.get(keyByteArray).isPresent()) {
                this.db.delete(this.columnFamily, this.writeOptions, keyBytes);
                this.cache.put(keyByteArray, this.ref(null));
            }
        }
        catch (RocksDBException e) {
            throw new IOException(e);
        }
    }

    private V deserializeValue(byte[] valueBytes) throws IOException {
        this.valueInputView.setBuffer(valueBytes);
        return (V)this.valueSerializer.deserialize(this.valueInputView);
    }

    private byte[] serializeValue(V value) throws IOException {
        this.valueOutputView.clear();
        this.valueSerializer.serialize(value, this.valueOutputView);
        return this.valueOutputView.getCopyOfBuffer();
    }
}

