/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.lookup;

import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.paimon.data.serializer.Serializer;
import org.apache.paimon.flink.RocksDBOptions;
import org.apache.paimon.flink.lookup.RocksDBListState;
import org.apache.paimon.flink.lookup.RocksDBSetState;
import org.apache.paimon.flink.lookup.RocksDBValueState;
import org.apache.paimon.options.Options;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.DBOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;

public class RocksDBStateFactory
implements Closeable {
    public static final String MERGE_OPERATOR_NAME = "stringappendtest";
    private RocksDB db;
    private final ColumnFamilyOptions columnFamilyOptions;

    public RocksDBStateFactory(String path, Options conf) throws IOException {
        DBOptions dbOptions = RocksDBOptions.createDBOptions(new DBOptions().setUseFsync(false).setStatsDumpPeriodSec(0).setCreateIfMissing(true), conf);
        this.columnFamilyOptions = RocksDBOptions.createColumnOptions(new ColumnFamilyOptions(), conf).setMergeOperatorName(MERGE_OPERATOR_NAME);
        try {
            this.db = RocksDB.open((org.rocksdb.Options)new org.rocksdb.Options(dbOptions, this.columnFamilyOptions), (String)path);
        }
        catch (RocksDBException e) {
            throw new IOException("Error while opening RocksDB instance.", e);
        }
    }

    public <K, V> RocksDBValueState<K, V> valueState(String name, Serializer<K> keySerializer, Serializer<V> valueSerializer, long lruCacheSize) throws IOException {
        return new RocksDBValueState<K, V>(this.db, this.createColumnFamily(name), keySerializer, valueSerializer, lruCacheSize);
    }

    public <K, V> RocksDBSetState<K, V> setState(String name, Serializer<K> keySerializer, Serializer<V> valueSerializer, long lruCacheSize) throws IOException {
        return new RocksDBSetState<K, V>(this.db, this.createColumnFamily(name), keySerializer, valueSerializer, lruCacheSize);
    }

    public <K, V> RocksDBListState<K, V> listState(String name, Serializer<K> keySerializer, Serializer<V> valueSerializer, long lruCacheSize) throws IOException {
        return new RocksDBListState<K, V>(this.db, this.createColumnFamily(name), keySerializer, valueSerializer, lruCacheSize);
    }

    private ColumnFamilyHandle createColumnFamily(String name) throws IOException {
        try {
            return this.db.createColumnFamily(new ColumnFamilyDescriptor(name.getBytes(StandardCharsets.UTF_8), this.columnFamilyOptions));
        }
        catch (RocksDBException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.db != null) {
            this.db.close();
            this.db = null;
        }
    }
}

