/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.lookup;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.serializer.InternalSerializers;
import org.apache.paimon.flink.lookup.LookupTable;
import org.apache.paimon.flink.lookup.RocksDBStateFactory;
import org.apache.paimon.flink.lookup.RocksDBValueState;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.KeyProjectedRow;
import org.apache.paimon.utils.TypeUtils;

public class PrimaryKeyLookupTable
implements LookupTable {
    protected final RocksDBValueState<InternalRow, InternalRow> tableState;
    protected final Predicate<InternalRow> recordFilter;
    protected int[] primaryKeyMapping;
    protected final KeyProjectedRow primaryKey;

    public PrimaryKeyLookupTable(RocksDBStateFactory stateFactory, RowType rowType, List<String> primaryKey, Predicate<InternalRow> recordFilter, long lruCacheSize) throws IOException {
        List<String> fieldNames = rowType.getFieldNames();
        this.primaryKeyMapping = primaryKey.stream().mapToInt(fieldNames::indexOf).toArray();
        this.primaryKey = new KeyProjectedRow(this.primaryKeyMapping);
        this.tableState = stateFactory.valueState("table", InternalSerializers.create(TypeUtils.project(rowType, this.primaryKeyMapping)), InternalSerializers.create(rowType), lruCacheSize);
        this.recordFilter = recordFilter;
    }

    @Override
    public List<InternalRow> get(InternalRow key) throws IOException {
        InternalRow value = this.tableState.get(key);
        return value == null ? Collections.emptyList() : Collections.singletonList(value);
    }

    @Override
    public void refresh(Iterator<InternalRow> incremental) throws IOException {
        while (incremental.hasNext()) {
            InternalRow row = incremental.next();
            this.primaryKey.replaceRow(row);
            if (row.getRowKind() == RowKind.INSERT || row.getRowKind() == RowKind.UPDATE_AFTER) {
                if (this.recordFilter.test(row)) {
                    this.tableState.put(this.primaryKey, row);
                    continue;
                }
                this.tableState.delete(this.primaryKey);
                continue;
            }
            this.tableState.delete(this.primaryKey);
        }
    }
}

