/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.lookup;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.flink.lookup.NoPrimaryKeyLookupTable;
import org.apache.paimon.flink.lookup.PrimaryKeyLookupTable;
import org.apache.paimon.flink.lookup.RocksDBStateFactory;
import org.apache.paimon.flink.lookup.SecondaryIndexLookupTable;
import org.apache.paimon.types.RowType;

public interface LookupTable {
    public List<InternalRow> get(InternalRow var1) throws IOException;

    public void refresh(Iterator<InternalRow> var1) throws IOException;

    public static LookupTable create(RocksDBStateFactory stateFactory, RowType rowType, List<String> primaryKey, List<String> joinKey, Predicate<InternalRow> recordFilter, long lruCacheSize) throws IOException {
        if (primaryKey.isEmpty()) {
            return new NoPrimaryKeyLookupTable(stateFactory, rowType, joinKey, recordFilter, lruCacheSize);
        }
        if (new HashSet<String>(primaryKey).equals(new HashSet<String>(joinKey))) {
            return new PrimaryKeyLookupTable(stateFactory, rowType, joinKey, recordFilter, lruCacheSize);
        }
        return new SecondaryIndexLookupTable(stateFactory, rowType, primaryKey, joinKey, recordFilter, lruCacheSize);
    }
}

