/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.log;

import javax.annotation.Nullable;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.format.Format;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.DeserializationFormatFactory;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.SerializationFormatFactory;
import org.apache.flink.types.RowKind;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.factories.Factory;
import org.apache.paimon.factories.FactoryUtil;
import org.apache.paimon.flink.factories.FlinkFactoryUtil;
import org.apache.paimon.flink.log.LogSinkProvider;
import org.apache.paimon.flink.log.LogSourceProvider;
import org.apache.paimon.flink.log.LogStoreRegister;
import org.apache.paimon.options.Options;

public interface LogStoreTableFactory
extends Factory {
    public LogSourceProvider createSourceProvider(DynamicTableFactory.Context var1, DynamicTableSource.Context var2, @Nullable int[][] var3);

    public LogSinkProvider createSinkProvider(DynamicTableFactory.Context var1, DynamicTableSink.Context var2);

    public LogStoreRegister createRegister(RegisterContext var1);

    public static ConfigOption<String> logKeyFormat() {
        return ConfigOptions.key((String)CoreOptions.LOG_KEY_FORMAT.key()).stringType().defaultValue((Object)CoreOptions.LOG_KEY_FORMAT.defaultValue());
    }

    public static ConfigOption<String> logFormat() {
        return ConfigOptions.key((String)CoreOptions.LOG_FORMAT.key()).stringType().defaultValue((Object)CoreOptions.LOG_FORMAT.defaultValue());
    }

    public static LogStoreTableFactory discoverLogStoreFactory(ClassLoader cl, String identifier) {
        return FactoryUtil.discoverFactory(cl, LogStoreTableFactory.class, identifier);
    }

    public static DecodingFormat<DeserializationSchema<RowData>> getKeyDecodingFormat(FlinkFactoryUtil.FlinkTableFactoryHelper helper) {
        DecodingFormat format = helper.discoverDecodingFormat(DeserializationFormatFactory.class, LogStoreTableFactory.logKeyFormat());
        LogStoreTableFactory.validateKeyFormat(format, (String)helper.getOptions().get(LogStoreTableFactory.logKeyFormat()));
        return format;
    }

    public static EncodingFormat<SerializationSchema<RowData>> getKeyEncodingFormat(FlinkFactoryUtil.FlinkTableFactoryHelper helper) {
        EncodingFormat format = helper.discoverEncodingFormat(SerializationFormatFactory.class, LogStoreTableFactory.logKeyFormat());
        LogStoreTableFactory.validateKeyFormat(format, (String)helper.getOptions().get(LogStoreTableFactory.logKeyFormat()));
        return format;
    }

    public static DecodingFormat<DeserializationSchema<RowData>> getValueDecodingFormat(FlinkFactoryUtil.FlinkTableFactoryHelper helper) {
        DecodingFormat format = helper.discoverDecodingFormat(DeserializationFormatFactory.class, LogStoreTableFactory.logFormat());
        LogStoreTableFactory.validateValueFormat(format, (String)helper.getOptions().get(LogStoreTableFactory.logFormat()));
        return format;
    }

    public static EncodingFormat<SerializationSchema<RowData>> getValueEncodingFormat(FlinkFactoryUtil.FlinkTableFactoryHelper helper) {
        EncodingFormat format = helper.discoverEncodingFormat(SerializationFormatFactory.class, LogStoreTableFactory.logFormat());
        LogStoreTableFactory.validateValueFormat(format, (String)helper.getOptions().get(LogStoreTableFactory.logFormat()));
        return format;
    }

    public static void validateKeyFormat(Format format, String name) {
        if (!format.getChangelogMode().containsOnly(RowKind.INSERT)) {
            throw new ValidationException(String.format("A key format should only deal with INSERT-only records. But %s has a changelog mode of %s.", name, format.getChangelogMode()));
        }
    }

    public static void validateValueFormat(Format format, String name) {
        if (!format.getChangelogMode().equals((Object)ChangelogMode.all())) {
            throw new ValidationException(String.format("A value format should deal with all records. But %s has a changelog mode of %s.", name, format.getChangelogMode()));
        }
    }

    public static interface RegisterContext {
        public Options getOptions();

        public Identifier getIdentifier();
    }
}

