/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc.mysql.schema;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.action.cdc.mysql.schema.MySqlSchema;
import org.apache.paimon.flink.action.cdc.mysql.schema.MySqlTableInfo;
import org.apache.paimon.utils.Preconditions;

public class ShardsMergedMySqlTableInfo
implements MySqlTableInfo {
    private final List<String> fromDatabases = new ArrayList<String>();
    private String tableName;
    private MySqlSchema schema;

    public void init(Identifier identifier, MySqlSchema schema) {
        this.fromDatabases.add(identifier.getDatabaseName());
        this.tableName = identifier.getObjectName();
        this.schema = schema;
    }

    public ShardsMergedMySqlTableInfo merge(Identifier otherTableId, MySqlSchema other) {
        Preconditions.checkArgument(otherTableId.getObjectName().equals(this.tableName), "Table to be merged '%s' should equals to current table name '%s'.", otherTableId.getObjectName(), this.tableName);
        this.schema = this.schema.merge(this.location(), otherTableId.getFullName(), other);
        this.fromDatabases.add(otherTableId.getDatabaseName());
        return this;
    }

    @Override
    public String location() {
        return String.format("[%s].%s", String.join((CharSequence)",", this.fromDatabases), this.tableName);
    }

    @Override
    public List<Identifier> identifiers() {
        return this.fromDatabases.stream().map(databaseName -> Identifier.create(databaseName, this.tableName)).collect(Collectors.toList());
    }

    @Override
    public String tableName() {
        return this.tableName;
    }

    @Override
    public String toPaimonTableName() {
        return this.tableName;
    }

    @Override
    public MySqlSchema schema() {
        return Preconditions.checkNotNull(this.schema, "MySqlSchema hasn't been set.");
    }
}

