/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc.mysql.schema;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.paimon.flink.action.cdc.TypeMapping;
import org.apache.paimon.flink.action.cdc.mysql.MySqlTypeUtils;
import org.apache.paimon.flink.sink.cdc.UpdatedDataFieldsProcessFunction;
import org.apache.paimon.types.DataType;
import org.apache.paimon.utils.Pair;

public class MySqlSchema {
    private final LinkedHashMap<String, Pair<DataType, String>> fields;
    private final List<String> primaryKeys;

    private MySqlSchema(LinkedHashMap<String, Pair<DataType, String>> fields, List<String> primaryKeys) {
        this.fields = fields;
        this.primaryKeys = primaryKeys;
    }

    public static MySqlSchema buildSchema(DatabaseMetaData metaData, String databaseName, String tableName, TypeMapping typeMapping) throws SQLException {
        LinkedHashMap<String, Pair<DataType, String>> fields = new LinkedHashMap<String, Pair<DataType, String>>();
        try (ResultSet rs = metaData.getColumns(databaseName, null, tableName, null);){
            while (rs.next()) {
                String fieldName = rs.getString("COLUMN_NAME");
                String fieldType = rs.getString("TYPE_NAME");
                String fieldComment = rs.getString("REMARKS");
                Integer precision = rs.getInt("COLUMN_SIZE");
                if (rs.wasNull()) {
                    precision = null;
                }
                Integer scale = rs.getInt("DECIMAL_DIGITS");
                if (rs.wasNull()) {
                    scale = null;
                }
                DataType paimonType = MySqlTypeUtils.toDataType(fieldType, precision, scale, typeMapping);
                fields.put(fieldName, Pair.of(paimonType, fieldComment));
            }
        }
        ArrayList<String> primaryKeys = new ArrayList<String>();
        try (ResultSet rs = metaData.getPrimaryKeys(databaseName, null, tableName);){
            while (rs.next()) {
                String fieldName = rs.getString("COLUMN_NAME");
                primaryKeys.add(fieldName);
            }
        }
        return new MySqlSchema(fields, primaryKeys);
    }

    public LinkedHashMap<String, Pair<DataType, String>> fields() {
        return this.fields;
    }

    public List<String> primaryKeys() {
        return this.primaryKeys;
    }

    public Map<String, DataType> typeMapping() {
        HashMap<String, DataType> typeMapping = new HashMap<String, DataType>();
        this.fields.forEach((name, pair) -> {
            DataType cfr_ignored_0 = (DataType)typeMapping.put((String)name, (DataType)pair.getLeft());
        });
        return typeMapping;
    }

    public MySqlSchema merge(String currentTable, String otherTable, MySqlSchema other) {
        for (Map.Entry<String, Pair<DataType, String>> entry : other.fields.entrySet()) {
            String fieldName = entry.getKey();
            DataType newType = entry.getValue().getLeft();
            if (this.fields.containsKey(fieldName)) {
                DataType oldType = this.fields.get(fieldName).getLeft();
                switch (UpdatedDataFieldsProcessFunction.canConvert(oldType, newType)) {
                    case CONVERT: {
                        this.fields.put(fieldName, Pair.of(newType, entry.getValue().getRight()));
                        break;
                    }
                    case EXCEPTION: {
                        throw new IllegalArgumentException(String.format("Column %s have different types when merging schemas.\nCurrent table '%s' fields: %s\nTo be merged table '%s' fields: %s", fieldName, currentTable, this.fieldsToString(), otherTable, other.fieldsToString()));
                    }
                }
                continue;
            }
            this.fields.put(fieldName, Pair.of(newType, entry.getValue().getRight()));
        }
        if (!this.primaryKeys.equals(other.primaryKeys)) {
            this.primaryKeys.clear();
        }
        return this;
    }

    private String fieldsToString() {
        return "[" + this.fields.entrySet().stream().map(e -> String.format("%s %s", e.getKey(), ((Pair)e.getValue()).getLeft())).collect(Collectors.joining(",")) + "]";
    }
}

