/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc.mongodb.strategy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.configuration.Configuration;
import org.apache.paimon.flink.action.cdc.mongodb.JsonParserUtils;
import org.apache.paimon.flink.action.cdc.mongodb.ModeEnum;
import org.apache.paimon.flink.action.cdc.mongodb.MongoDBActionUtils;
import org.apache.paimon.flink.sink.cdc.RichCdcMultiplexRecord;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.utils.Preconditions;

public interface MongoVersionStrategy {
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public List<RichCdcMultiplexRecord> extractRecords(JsonNode var1) throws JsonProcessingException;

    default public List<String> extractPrimaryKeys() {
        ArrayList<String> primaryKeys = new ArrayList<String>();
        primaryKeys.add("_id");
        return primaryKeys;
    }

    default public Map<String, String> extractRow(String record) {
        return JsonParserUtils.extractMap(record);
    }

    default public Map<String, String> keyCaseInsensitive(Map<String, String> origin) {
        HashMap<String, String> keyCaseInsensitive = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : origin.entrySet()) {
            String fieldName = entry.getKey().toLowerCase();
            Preconditions.checkArgument(!keyCaseInsensitive.containsKey(fieldName), "Duplicate key appears when converting map keys to case-insensitive form. Original map is:\n%s", origin);
            keyCaseInsensitive.put(fieldName, entry.getValue());
        }
        return keyCaseInsensitive;
    }

    default public Map<String, String> getExtractRow(JsonNode jsonNode, LinkedHashMap<String, DataType> paimonFieldTypes, boolean caseSensitive, Configuration mongodbConfig) throws JsonProcessingException {
        ModeEnum mode = ModeEnum.valueOf(mongodbConfig.getString(MongoDBActionUtils.START_MODE).toUpperCase());
        ObjectNode objectNode = (ObjectNode)OBJECT_MAPPER.readTree(jsonNode.asText());
        Object document = objectNode.set("_id", objectNode.get("_id").get("$oid"));
        switch (mode) {
            case SPECIFIED: {
                Map<String, String> specifiedRow = MongoVersionStrategy.getSpecifiedRow(((JsonNode)document).toString(), mongodbConfig.getString(MongoDBActionUtils.PARSER_PATH), mongodbConfig.getString(MongoDBActionUtils.FIELD_NAME), paimonFieldTypes);
                return caseSensitive ? specifiedRow : this.keyCaseInsensitive(specifiedRow);
            }
            case DYNAMIC: {
                Map<String, String> dynamicRow = this.getDynamicRow(((JsonNode)document).toString(), paimonFieldTypes);
                return caseSensitive ? dynamicRow : this.keyCaseInsensitive(dynamicRow);
            }
        }
        throw new RuntimeException();
    }

    default public Map<String, String> getDynamicRow(String evaluate, LinkedHashMap<String, DataType> paimonFieldTypes) {
        String[] columns;
        LinkedHashMap<String, String> linkedHashMap = JsonParserUtils.extractMap(evaluate);
        Set keySet = linkedHashMap.keySet();
        for (String column : columns = keySet.toArray(new String[0])) {
            paimonFieldTypes.put(column, DataTypes.STRING());
        }
        return this.extractRow(evaluate);
    }

    public static Map<String, String> getSpecifiedRow(String record, String parsePath, String fileName, LinkedHashMap<String, DataType> paimonFieldTypes) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        String[] columnNames = fileName.split(",");
        String[] parseNames = parsePath.split(",");
        for (int i = 0; i < parseNames.length; ++i) {
            paimonFieldTypes.put(columnNames[i], DataTypes.STRING());
            String evaluate = JsonParserUtils.evaluate(record, "$." + parseNames[i]);
            if (evaluate == null) {
                resultMap.put(columnNames[i], "{}");
                continue;
            }
            resultMap.put(columnNames[i], evaluate);
        }
        return resultMap;
    }
}

