/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc.mongodb.strategy;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.configuration.Configuration;
import org.apache.paimon.flink.action.cdc.mongodb.strategy.MongoVersionStrategy;
import org.apache.paimon.flink.sink.cdc.CdcRecord;
import org.apache.paimon.flink.sink.cdc.RichCdcMultiplexRecord;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.RowKind;

public class Mongo4VersionStrategy
implements MongoVersionStrategy {
    private static final String FIELD_TYPE = "operationType";
    private static final String FIELD_DATA = "fullDocument";
    private static final String OP_UPDATE = "update";
    private static final String OP_INSERT = "insert";
    private static final String OP_REPLACE = "replace";
    private final String databaseName;
    private final String collection;
    private final boolean caseSensitive;
    private final Configuration mongodbConfig;

    public Mongo4VersionStrategy(String databaseName, String collection, boolean caseSensitive, Configuration mongodbConfig) {
        this.databaseName = databaseName;
        this.collection = collection;
        this.caseSensitive = caseSensitive;
        this.mongodbConfig = mongodbConfig;
    }

    @Override
    public List<RichCdcMultiplexRecord> extractRecords(JsonNode root) throws JsonProcessingException {
        ArrayList<RichCdcMultiplexRecord> records = new ArrayList<RichCdcMultiplexRecord>();
        LinkedHashMap<String, DataType> paimonFieldTypes = new LinkedHashMap<String, DataType>();
        String op = root.get(FIELD_TYPE).asText();
        JsonNode fullDocument = root.get(FIELD_DATA);
        switch (op) {
            case "insert": {
                Map<String, String> insert = this.getExtractRow(fullDocument, paimonFieldTypes, this.caseSensitive, this.mongodbConfig);
                records.add(new RichCdcMultiplexRecord(this.databaseName, this.collection, paimonFieldTypes, this.extractPrimaryKeys(), new CdcRecord(RowKind.INSERT, insert)));
                break;
            }
            case "replace": 
            case "update": {
                Map<String, String> after = this.getExtractRow(fullDocument, paimonFieldTypes, this.caseSensitive, this.mongodbConfig);
                records.add(new RichCdcMultiplexRecord(this.databaseName, this.collection, paimonFieldTypes, this.extractPrimaryKeys(), new CdcRecord(RowKind.UPDATE_AFTER, after)));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown record type: " + op);
            }
        }
        return records;
    }
}

