/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc.mongodb;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.core.JsonFactory;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.JavaType;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.type.MapType;

public class JsonParserUtils
implements Serializable {
    private static final Pattern patternKey = Pattern.compile("^([a-zA-Z0-9_\\-:\\s]+).*");
    private static final Pattern patternIndex = Pattern.compile("\\[([0-9]+|\\*)]");
    private static final JsonFactory JSON_FACTORY = new JsonFactory();
    private static final ObjectMapper MAPPER;
    private static final MapType MAP_TYPE;
    static Map<String, Object> extractObjectCache;
    static Map<String, String[]> pathExprCache;
    static Map<String, ArrayList<String>> indexListCache;
    static Map<String, String> mKeyGroupCache;
    static Map<String, Boolean> mKeyMatchesCache;

    public static String evaluate(String jsonString, String pathString) {
        if (jsonString == null || jsonString.equals("") || pathString == null || pathString.equals("")) {
            return null;
        }
        String[] pathExpr = pathExprCache.computeIfAbsent(pathString, s -> s.split("\\.", -1));
        if (!pathExpr[0].equalsIgnoreCase("$")) {
            return null;
        }
        Object extractObject = extractObjectCache.get(jsonString);
        if (extractObject == null) {
            try {
                extractObject = MAPPER.readValue(jsonString, (JavaType)MAP_TYPE);
            }
            catch (Exception e) {
                return null;
            }
            extractObjectCache.put(jsonString, extractObject);
        }
        for (int i = 1; i < pathExpr.length; ++i) {
            if (extractObject == null) {
                return null;
            }
            extractObject = JsonParserUtils.extract(extractObject, pathExpr[i]);
        }
        if (extractObject instanceof Map || extractObject instanceof List) {
            try {
                return MAPPER.writeValueAsString(extractObject);
            }
            catch (Exception e) {
                return null;
            }
        }
        if (extractObject != null) {
            return extractObject.toString();
        }
        return null;
    }

    private static Object extract(Object json, String path) {
        Matcher mKey = null;
        Boolean mKeyMatches = mKeyMatchesCache.get(path);
        if (mKeyMatches == null) {
            mKey = patternKey.matcher(path);
            mKeyMatches = mKey.matches() ? Boolean.TRUE : Boolean.FALSE;
            mKeyMatchesCache.put(path, mKeyMatches);
        }
        if (!mKeyMatches.booleanValue()) {
            return null;
        }
        String mKeyGroup1 = mKeyGroupCache.get(path);
        if (mKeyGroup1 == null) {
            if (mKey == null) {
                mKey = patternKey.matcher(path);
            }
            mKeyGroup1 = mKey.group(1);
            mKeyGroupCache.put(path, mKeyGroup1);
        }
        json = JsonParserUtils.extract_json_key(json, mKeyGroup1);
        ArrayList<String> indexList = indexListCache.get(path);
        if (indexList == null) {
            Matcher mIndex = patternIndex.matcher(path);
            indexList = new ArrayList();
            while (mIndex.find()) {
                indexList.add(mIndex.group(1));
            }
            indexListCache.put(path, indexList);
        }
        if (indexList.size() > 0) {
            json = JsonParserUtils.extract_json_withIndex(json, indexList);
        }
        return json;
    }

    private static Object extract_json_withIndex(Object json, ArrayList<String> indexList) {
        ArrayList<Object> jsonList = new ArrayList<Object>();
        jsonList.add(json);
        for (String index : indexList) {
            ArrayList tmpJsonList = new ArrayList();
            if (index.equalsIgnoreCase("*")) {
                for (Object e : jsonList) {
                    if (!(e instanceof List)) continue;
                    tmpJsonList.addAll((List)e);
                }
                jsonList = tmpJsonList;
                continue;
            }
            for (int i = 0; i < jsonList.size(); ++i) {
                Object e = jsonList.get(i);
                int indexValue = Integer.parseInt(index);
                if (!(e instanceof List)) continue;
                if (indexValue >= ((List)e).size()) {
                    return null;
                }
                tmpJsonList.add(((List)e).get(indexValue));
                jsonList = tmpJsonList;
            }
        }
        if (jsonList.isEmpty()) {
            return null;
        }
        return jsonList.size() > 1 ? new ArrayList(jsonList) : jsonList.get(0);
    }

    private static Object extract_json_key(Object json, String path) {
        if (json instanceof List) {
            ArrayList jsonArray = new ArrayList();
            for (int i = 0; i < ((List)json).size(); ++i) {
                Object jsonElem = ((List)json).get(i);
                if (!(jsonElem instanceof Map)) continue;
                Object jsonObj = ((Map)jsonElem).get(path);
                if (jsonObj instanceof List) {
                    jsonArray.addAll((List)jsonObj);
                    continue;
                }
                if (jsonObj == null) continue;
                jsonArray.add(jsonObj);
            }
            return jsonArray.size() == 0 ? null : jsonArray;
        }
        if (json instanceof Map) {
            return ((Map)json).get(path);
        }
        return null;
    }

    public static LinkedHashMap<String, String> extractMap(String jsonString) {
        try {
            LinkedHashMap originalMap = (LinkedHashMap)MAPPER.readValue(jsonString, (JavaType)MAP_TYPE);
            LinkedHashMap<String, String> stringMap = new LinkedHashMap<String, String>();
            originalMap.forEach((key, value) -> {
                String stringValue = Objects.toString(value, null);
                stringMap.put(key.toLowerCase(), stringValue);
            });
            return stringMap;
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        JSON_FACTORY.enable(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS);
        MAPPER = new ObjectMapper(JSON_FACTORY);
        MAP_TYPE = MAPPER.getTypeFactory().constructMapType(Map.class, String.class, Object.class);
        extractObjectCache = new HashCache<String, Object>();
        pathExprCache = new HashCache<String, String[]>();
        indexListCache = new HashCache<String, ArrayList<String>>();
        mKeyGroupCache = new HashCache<String, String>();
        mKeyMatchesCache = new HashCache<String, Boolean>();
    }

    static class HashCache<K, V>
    extends LinkedHashMap<K, V> {
        private static final int CACHE_SIZE = 16;
        private static final int INIT_SIZE = 32;
        private static final float LOAD_FACTOR = 0.6f;
        private static final long serialVersionUID = 1L;

        HashCache() {
            super(32, 0.6f);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > 16;
        }
    }
}

