/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.Map;
import java.util.Optional;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.utils.MultipleParameterTool;
import org.apache.paimon.flink.action.Action;
import org.apache.paimon.flink.action.ActionFactory;
import org.apache.paimon.flink.action.ResetConsumerAction;

public class ResetConsumerActionFactory
implements ActionFactory {
    public static final String IDENTIFIER = "reset-consumer";

    @Override
    public String identifier() {
        return IDENTIFIER;
    }

    @Override
    public Optional<Action> create(MultipleParameterTool params) {
        this.checkRequiredArgument(params, "consumer-id");
        this.checkRequiredArgument(params, "next-snapshot");
        Tuple3<String, String, String> tablePath = this.getTablePath(params);
        Map<String, String> catalogConfig = this.optionalConfigMap(params, "catalog-conf");
        String consumerId = params.get("consumer-id");
        long nextSnapshotId = Long.parseLong(params.get("next-snapshot"));
        ResetConsumerAction action = new ResetConsumerAction((String)tablePath.f0, (String)tablePath.f1, (String)tablePath.f2, catalogConfig, consumerId, nextSnapshotId);
        return Optional.of(action);
    }

    @Override
    public void printHelp() {
        System.out.println("Action \"reset-consumer\" reset a consumer from the given next snapshot.");
        System.out.println();
        System.out.println("Syntax:");
        System.out.println("  reset-consumer --warehouse <warehouse-path> --database <database-name> --table <table-name> --consumer-id <consumer-id> --next-snapshot <next-snapshot-id>");
        System.out.println();
    }
}

