/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.Map;
import java.util.Optional;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.utils.MultipleParameterTool;
import org.apache.paimon.flink.action.Action;
import org.apache.paimon.flink.action.ActionFactory;
import org.apache.paimon.flink.action.DeleteAction;

public class DeleteActionFactory
implements ActionFactory {
    public static final String IDENTIFIER = "delete";

    @Override
    public String identifier() {
        return IDENTIFIER;
    }

    @Override
    public Optional<Action> create(MultipleParameterTool params) {
        Tuple3<String, String, String> tablePath = this.getTablePath(params);
        String filter = params.get("where");
        if (filter == null) {
            throw new IllegalArgumentException("Please specify deletion filter. If you want to delete all records, please use overwrite (see doc).");
        }
        Map<String, String> catalogConfig = this.optionalConfigMap(params, "catalog-conf");
        DeleteAction action = new DeleteAction((String)tablePath.f0, (String)tablePath.f1, (String)tablePath.f2, filter, catalogConfig);
        return Optional.of(action);
    }

    @Override
    public void printHelp() {
        System.out.println("Action \"delete\" deletes data from a table.");
        System.out.println();
        System.out.println("Syntax:");
        System.out.println("  delete --warehouse <warehouse-path> --database <database-name> --table <table-name> --where <filter_spec>");
        System.out.println("  delete --path <table-path> --where <filter_spec>");
        System.out.println();
        System.out.println("The '--where <filter_spec>' part is equal to the 'WHERE' clause in SQL DELETE statement. If you want to delete all records, please use overwrite (see doc).");
        System.out.println();
        System.out.println("Examples:");
        System.out.println("  delete --path hdfs:///path/to/warehouse/test_db.db/test_table --where id > (SELECT count(*) FROM employee)");
        System.out.println("  It's equal to 'DELETE FROM test_table WHERE id > (SELECT count(*) FROM employee)");
    }
}

