/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.data.RowData;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.action.ActionBase;
import org.apache.paimon.flink.compact.UnawareBucketCompactionTopoBuilder;
import org.apache.paimon.flink.sink.CompactorSinkBuilder;
import org.apache.paimon.flink.source.CompactorSourceBuilder;
import org.apache.paimon.flink.utils.StreamExecutionEnvironmentUtils;
import org.apache.paimon.table.AppendOnlyFileStoreTable;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactDatabaseAction
extends ActionBase {
    private static final Logger LOG = LoggerFactory.getLogger(CompactDatabaseAction.class);
    private final Pattern includingPattern;
    private final Pattern excludingPattern;
    private final String database;
    private final Map<String, Table> tableMap = new HashMap<String, Table>();

    public CompactDatabaseAction(String warehouse, String database, @Nullable String includingTables, @Nullable String excludingTables, Map<String, String> catalogConfig) {
        super(warehouse, catalogConfig);
        this.database = database;
        this.includingPattern = Pattern.compile(includingTables == null ? ".*" : includingTables);
        this.excludingPattern = excludingTables == null ? null : Pattern.compile(excludingTables);
    }

    private boolean shouldCompactionTable(String paimonFullTableName) {
        boolean shouldCompaction = this.includingPattern.matcher(paimonFullTableName).matches();
        if (this.excludingPattern != null) {
            boolean bl = shouldCompaction = shouldCompaction && !this.excludingPattern.matcher(paimonFullTableName).matches();
        }
        if (!shouldCompaction) {
            LOG.debug("Source table '{}' is excluded.", (Object)paimonFullTableName);
        }
        return shouldCompaction;
    }

    public void build(StreamExecutionEnvironment env) {
        try {
            Pattern databasePattern = Pattern.compile(this.database);
            List<String> databases = this.catalog.listDatabases();
            for (String string : databases) {
                Matcher databaseMatcher = databasePattern.matcher(string);
                if (!databaseMatcher.matches()) continue;
                List<String> tables = this.catalog.listTables(string);
                for (String tableName : tables) {
                    String fullTableName = String.format("%s.%s", string, tableName);
                    if (this.shouldCompactionTable(fullTableName)) {
                        Table table = this.catalog.getTable(Identifier.create(string, tableName));
                        if (!(table instanceof FileStoreTable)) {
                            LOG.error(String.format("Only FileStoreTable supports compact action. The table type is '%s'.", table.getClass().getName()));
                            continue;
                        }
                        table = table.copy(Collections.singletonMap(CoreOptions.WRITE_ONLY.key(), "false"));
                        this.tableMap.put(fullTableName, table);
                        continue;
                    }
                    LOG.debug("The table {} is excluded.", (Object)fullTableName);
                }
            }
        }
        catch (Catalog.DatabaseNotExistException | Catalog.TableNotExistException e) {
            throw new RuntimeException(e);
        }
        ReadableConfig conf = StreamExecutionEnvironmentUtils.getConfiguration(env);
        boolean isStreaming = conf.get(ExecutionOptions.RUNTIME_MODE) == RuntimeExecutionMode.STREAMING;
        block7: for (Map.Entry entry : this.tableMap.entrySet()) {
            FileStoreTable fileStoreTable = (FileStoreTable)entry.getValue();
            switch (fileStoreTable.bucketMode()) {
                case UNAWARE: {
                    this.buildForUnawareBucketCompaction(env, (String)entry.getKey(), (AppendOnlyFileStoreTable)entry.getValue(), isStreaming);
                    continue block7;
                }
            }
            this.buildForTraditionalCompaction(env, (String)entry.getKey(), fileStoreTable, isStreaming);
        }
    }

    private void buildForTraditionalCompaction(StreamExecutionEnvironment env, String fullName, FileStoreTable table, boolean isStreaming) {
        CompactorSourceBuilder sourceBuilder = new CompactorSourceBuilder(fullName, table);
        CompactorSinkBuilder sinkBuilder = new CompactorSinkBuilder(table);
        DataStreamSource<RowData> source = sourceBuilder.withEnv(env).withContinuousMode(isStreaming).build();
        sinkBuilder.withInput((DataStream<RowData>)source).build();
    }

    private void buildForUnawareBucketCompaction(StreamExecutionEnvironment env, String fullName, AppendOnlyFileStoreTable table, boolean isStreaming) {
        UnawareBucketCompactionTopoBuilder unawareBucketCompactionTopoBuilder = new UnawareBucketCompactionTopoBuilder(env, fullName, table);
        unawareBucketCompactionTopoBuilder.withContinuousMode(isStreaming);
        unawareBucketCompactionTopoBuilder.build();
    }

    @Override
    public void run() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        this.build(env);
        this.execute(env, "Compact database job");
    }
}

