/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.catalog.Catalog;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.flink.FlinkCatalog;
import org.apache.paimon.flink.FlinkCatalogFactory;
import org.apache.paimon.flink.LogicalTypeConversion;
import org.apache.paimon.flink.action.Action;
import org.apache.paimon.flink.utils.StreamExecutionEnvironmentUtils;
import org.apache.paimon.options.CatalogOptions;
import org.apache.paimon.options.Options;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeCasts;

public abstract class ActionBase
implements Action {
    private final Options catalogOptions;
    protected final org.apache.paimon.catalog.Catalog catalog;
    protected final FlinkCatalog flinkCatalog;
    protected final String catalogName = "paimon-" + UUID.randomUUID();
    protected final StreamExecutionEnvironment env;
    protected final StreamTableEnvironment batchTEnv;

    public ActionBase(String warehouse, Map<String, String> catalogConfig) {
        this.catalogOptions = Options.fromMap(catalogConfig);
        this.catalogOptions.set(CatalogOptions.WAREHOUSE, warehouse);
        this.catalog = FlinkCatalogFactory.createPaimonCatalog(this.catalogOptions);
        this.flinkCatalog = FlinkCatalogFactory.createCatalog(this.catalogName, this.catalog, this.catalogOptions);
        this.env = StreamExecutionEnvironment.getExecutionEnvironment();
        this.batchTEnv = StreamTableEnvironment.create((StreamExecutionEnvironment)this.env, (EnvironmentSettings)EnvironmentSettings.inBatchMode());
        this.batchTEnv.registerCatalog(this.flinkCatalog.getName(), (Catalog)this.flinkCatalog);
        this.batchTEnv.useCatalog(this.flinkCatalog.getName());
    }

    protected void execute(StreamExecutionEnvironment env, String defaultName) throws Exception {
        ReadableConfig conf = StreamExecutionEnvironmentUtils.getConfiguration(env);
        String name = conf.getOptional(PipelineOptions.NAME).orElse(defaultName);
        env.execute(name);
    }

    protected Catalog.Loader catalogLoader() {
        Options catalogOptions = this.catalogOptions;
        return () -> FlinkCatalogFactory.createPaimonCatalog(catalogOptions);
    }

    protected List<DataType> toPaimonTypes(List<org.apache.flink.table.types.DataType> flinkDataTypes) {
        return flinkDataTypes.stream().map(org.apache.flink.table.types.DataType::getLogicalType).map(LogicalTypeConversion::toDataType).collect(Collectors.toList());
    }

    protected boolean compatibleCheck(List<DataType> actualTypes, List<DataType> expectedTypes) {
        if (actualTypes.size() != expectedTypes.size()) {
            return false;
        }
        for (int i = 0; i < actualTypes.size(); ++i) {
            if (DataTypeCasts.supportsCompatibleCast(actualTypes.get(i), expectedTypes.get(i))) continue;
            return false;
        }
        return true;
    }
}

