/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.factories.CatalogFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.catalog.CatalogContext;
import org.apache.paimon.catalog.CatalogFactory;
import org.apache.paimon.flink.FlinkCatalog;
import org.apache.paimon.flink.FlinkCatalogOptions;
import org.apache.paimon.flink.FlinkFileIOLoader;
import org.apache.paimon.flink.FlinkGenericCatalog;
import org.apache.paimon.options.CatalogOptions;
import org.apache.paimon.options.Options;

public class FlinkGenericCatalogFactory
implements org.apache.flink.table.factories.CatalogFactory {
    public static final String IDENTIFIER = "paimon-generic";

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        return Collections.emptySet();
    }

    public Set<ConfigOption<?>> optionalOptions() {
        return Collections.emptySet();
    }

    public FlinkGenericCatalog createCatalog(CatalogFactory.Context context) {
        org.apache.flink.table.factories.CatalogFactory hiveFactory = FlinkGenericCatalogFactory.createHiveCatalogFactory(context.getClassLoader());
        Catalog catalog = hiveFactory.createCatalog(context);
        return FlinkGenericCatalogFactory.createCatalog(context.getClassLoader(), context.getOptions(), context.getName(), catalog);
    }

    @VisibleForTesting
    public static FlinkGenericCatalog createCatalog(ClassLoader cl, Map<String, String> optionMap, String name, Catalog flinkCatalog) {
        String warehouse = FlinkGenericCatalogFactory.extractWarehouse(flinkCatalog);
        Options options = Options.fromMap(optionMap);
        options.set(CatalogOptions.WAREHOUSE, warehouse);
        options.set(CatalogOptions.METASTORE, "hive");
        FlinkCatalog paimon = new FlinkCatalog(CatalogFactory.createCatalog(CatalogContext.create(options, new FlinkFileIOLoader()), cl), name, options.get(FlinkCatalogOptions.DEFAULT_DATABASE), cl, options);
        return new FlinkGenericCatalog(paimon, flinkCatalog);
    }

    private static org.apache.flink.table.factories.CatalogFactory createHiveCatalogFactory(ClassLoader cl) {
        return (org.apache.flink.table.factories.CatalogFactory)FactoryUtil.discoverFactory((ClassLoader)cl, org.apache.flink.table.factories.CatalogFactory.class, (String)"hive");
    }

    private static String extractWarehouse(Catalog catalog) {
        try {
            Field field = catalog.getClass().getDeclaredField("hiveConf");
            field.setAccessible(true);
            Object hiveConf = field.get(catalog);
            Method method = hiveConf.getClass().getMethod("get", String.class);
            return (String)method.invoke(hiveConf, "hive.metastore.warehouse.dir");
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

