/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableColumn;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.WatermarkSpec;
import org.apache.flink.table.api.constraints.UniqueConstraint;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.table.catalog.CatalogDatabaseImpl;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.catalog.CatalogPartition;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogTableImpl;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.TableChange;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.exceptions.DatabaseAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotEmptyException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.catalog.exceptions.FunctionNotExistException;
import org.apache.flink.table.catalog.exceptions.PartitionNotExistException;
import org.apache.flink.table.catalog.exceptions.TableAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.catalog.stats.CatalogColumnStatistics;
import org.apache.flink.table.catalog.stats.CatalogTableStatistics;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.factories.Factory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.catalog.AbstractCatalog;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.DataCatalogTable;
import org.apache.paimon.flink.FlinkCatalogOptions;
import org.apache.paimon.flink.FlinkTableFactory;
import org.apache.paimon.flink.LogicalTypeConversion;
import org.apache.paimon.flink.SystemCatalogTable;
import org.apache.paimon.flink.log.LogStoreRegister;
import org.apache.paimon.flink.utils.FlinkCatalogPropertiesUtil;
import org.apache.paimon.options.Options;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.schema.SchemaChange;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.StringUtils;

public class FlinkCatalog
extends org.apache.flink.table.catalog.AbstractCatalog {
    private final ClassLoader classLoader;
    private final Catalog catalog;
    private final boolean logStoreAutoRegister;
    private final Duration logStoreAutoRegisterTimeout;

    public FlinkCatalog(Catalog catalog, String name, String defaultDatabase, ClassLoader classLoader, Options options) {
        super(name, defaultDatabase);
        this.catalog = catalog;
        this.classLoader = classLoader;
        this.logStoreAutoRegister = options.get(FlinkCatalogOptions.LOG_SYSTEM_AUTO_REGISTER);
        this.logStoreAutoRegisterTimeout = options.get(FlinkCatalogOptions.REGISTER_TIMEOUT);
        try {
            this.catalog.createDatabase(defaultDatabase, true);
        }
        catch (Catalog.DatabaseAlreadyExistException databaseAlreadyExistException) {
            // empty catch block
        }
    }

    public Catalog catalog() {
        return this.catalog;
    }

    public Optional<Factory> getFactory() {
        return Optional.of(new FlinkTableFactory());
    }

    public List<String> listDatabases() throws CatalogException {
        return this.catalog.listDatabases();
    }

    public boolean databaseExists(String databaseName) throws CatalogException {
        return this.catalog.databaseExists(databaseName);
    }

    public CatalogDatabase getDatabase(String databaseName) throws CatalogException, DatabaseNotExistException {
        if (this.databaseExists(databaseName)) {
            return new CatalogDatabaseImpl(Collections.emptyMap(), null);
        }
        throw new DatabaseNotExistException(this.getName(), databaseName);
    }

    public void createDatabase(String name, CatalogDatabase database, boolean ignoreIfExists) throws DatabaseAlreadyExistException, CatalogException {
        if (database != null) {
            if (database.getProperties().size() > 0) {
                throw new UnsupportedOperationException("Create database with properties is unsupported.");
            }
            if (database.getDescription().isPresent() && !((String)database.getDescription().get()).equals("")) {
                throw new UnsupportedOperationException("Create database with description is unsupported.");
            }
        }
        try {
            this.catalog.createDatabase(name, ignoreIfExists);
        }
        catch (Catalog.DatabaseAlreadyExistException e) {
            throw new DatabaseAlreadyExistException(this.getName(), e.database());
        }
    }

    public void dropDatabase(String name, boolean ignoreIfNotExists, boolean cascade) throws DatabaseNotEmptyException, DatabaseNotExistException, CatalogException {
        try {
            this.catalog.dropDatabase(name, ignoreIfNotExists, cascade);
        }
        catch (Catalog.DatabaseNotEmptyException e) {
            throw new DatabaseNotEmptyException(this.getName(), e.database());
        }
        catch (Catalog.DatabaseNotExistException e) {
            throw new DatabaseNotExistException(this.getName(), e.database());
        }
    }

    public List<String> listTables(String databaseName) throws DatabaseNotExistException, CatalogException {
        try {
            return this.catalog.listTables(databaseName);
        }
        catch (Catalog.DatabaseNotExistException e) {
            throw new DatabaseNotExistException(this.getName(), e.database());
        }
    }

    public CatalogTable getTable(ObjectPath tablePath) throws TableNotExistException, CatalogException {
        Table table;
        try {
            table = this.catalog.getTable(FlinkCatalog.toIdentifier(tablePath));
        }
        catch (Catalog.TableNotExistException e) {
            throw new TableNotExistException(this.getName(), tablePath);
        }
        if (table instanceof FileStoreTable) {
            return this.toCatalogTable(table);
        }
        return new SystemCatalogTable(table);
    }

    public boolean tableExists(ObjectPath tablePath) throws CatalogException {
        return this.catalog.tableExists(FlinkCatalog.toIdentifier(tablePath));
    }

    public void dropTable(ObjectPath tablePath, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        Identifier identifier = FlinkCatalog.toIdentifier(tablePath);
        Table table = null;
        try {
            if (this.logStoreAutoRegister && this.catalog.tableExists(identifier)) {
                table = this.catalog.getTable(identifier);
            }
            this.catalog.dropTable(FlinkCatalog.toIdentifier(tablePath), ignoreIfNotExists);
            if (this.logStoreAutoRegister && table != null) {
                LogStoreRegister.unRegisterLogSystem(identifier, table.options(), this.classLoader);
            }
        }
        catch (Catalog.TableNotExistException e) {
            throw new TableNotExistException(this.getName(), tablePath);
        }
    }

    public void createTable(ObjectPath tablePath, CatalogBaseTable table, boolean ignoreIfExists) throws TableAlreadyExistException, DatabaseNotExistException, CatalogException {
        String specific;
        if (!(table instanceof CatalogTable)) {
            throw new UnsupportedOperationException("Only support CatalogTable, but is: " + table.getClass());
        }
        CatalogTable catalogTable = (CatalogTable)table;
        Map options = table.getOptions();
        String connector = (String)options.get(FactoryUtil.CONNECTOR.key());
        options.remove(FactoryUtil.CONNECTOR.key());
        if (!StringUtils.isNullOrWhitespaceOnly(connector) && !"paimon".equals(connector)) {
            throw new CatalogException("Paimon Catalog only supports paimon tables, but you specify  'connector'= '" + connector + "' when using Paimon Catalog\n You can create TEMPORARY table instead if you want to create the table of other connector.");
        }
        Identifier identifier = FlinkCatalog.toIdentifier(tablePath);
        if (this.logStoreAutoRegister) {
            if (this.catalog instanceof AbstractCatalog) {
                ((AbstractCatalog)this.catalog).copyTableDefaultOptions(options);
            }
            options.put(FlinkCatalogOptions.REGISTER_TIMEOUT.key(), this.logStoreAutoRegisterTimeout.toString());
            LogStoreRegister.registerLogSystem(this.catalog, identifier, options, this.classLoader);
        }
        if ((specific = (String)options.remove(CoreOptions.PATH.key())) != null || this.logStoreAutoRegister) {
            catalogTable = catalogTable.copy(options);
        }
        boolean unRegisterLogSystem = false;
        try {
            this.catalog.createTable(identifier, FlinkCatalog.fromCatalogTable(catalogTable), ignoreIfExists);
        }
        catch (Catalog.TableAlreadyExistException e) {
            unRegisterLogSystem = true;
            throw new TableAlreadyExistException(this.getName(), tablePath);
        }
        catch (Catalog.DatabaseNotExistException e) {
            unRegisterLogSystem = true;
            throw new DatabaseNotExistException(this.getName(), e.database());
        }
        finally {
            if (this.logStoreAutoRegister && unRegisterLogSystem) {
                LogStoreRegister.unRegisterLogSystem(identifier, options, this.classLoader);
            }
        }
    }

    private List<SchemaChange> toSchemaChange(TableChange change) {
        ArrayList<SchemaChange> schemaChanges = new ArrayList<SchemaChange>();
        if (change instanceof TableChange.AddColumn) {
            TableChange.AddColumn add = (TableChange.AddColumn)change;
            String comment = add.getColumn().getComment().orElse(null);
            SchemaChange.Move move = this.getMove(add.getPosition(), add.getColumn().getName());
            schemaChanges.add(SchemaChange.addColumn(add.getColumn().getName(), LogicalTypeConversion.toDataType(add.getColumn().getDataType().getLogicalType()), comment, move));
            return schemaChanges;
        }
        if (change instanceof TableChange.AddWatermark) {
            TableChange.AddWatermark add = (TableChange.AddWatermark)change;
            this.setWatermarkOptions(add.getWatermark(), schemaChanges);
            return schemaChanges;
        }
        if (change instanceof TableChange.DropColumn) {
            TableChange.DropColumn drop = (TableChange.DropColumn)change;
            schemaChanges.add(SchemaChange.dropColumn(drop.getColumnName()));
            return schemaChanges;
        }
        if (change instanceof TableChange.DropWatermark) {
            String watermarkPrefix = FlinkCatalogPropertiesUtil.compoundKey("schema", "watermark", 0);
            schemaChanges.add(SchemaChange.removeOption(FlinkCatalogPropertiesUtil.compoundKey(watermarkPrefix, "rowtime")));
            schemaChanges.add(SchemaChange.removeOption(FlinkCatalogPropertiesUtil.compoundKey(watermarkPrefix, "strategy.expr")));
            schemaChanges.add(SchemaChange.removeOption(FlinkCatalogPropertiesUtil.compoundKey(watermarkPrefix, "strategy.data-type")));
            return schemaChanges;
        }
        if (change instanceof TableChange.ModifyColumnName) {
            TableChange.ModifyColumnName modify = (TableChange.ModifyColumnName)change;
            schemaChanges.add(SchemaChange.renameColumn(modify.getOldColumnName(), modify.getNewColumnName()));
            return schemaChanges;
        }
        if (change instanceof TableChange.ModifyPhysicalColumnType) {
            TableChange.ModifyPhysicalColumnType modify = (TableChange.ModifyPhysicalColumnType)change;
            LogicalType newColumnType = modify.getNewType().getLogicalType();
            LogicalType oldColumnType = modify.getOldColumn().getDataType().getLogicalType();
            if (newColumnType.isNullable() != oldColumnType.isNullable()) {
                schemaChanges.add(SchemaChange.updateColumnNullability(modify.getNewColumn().getName(), newColumnType.isNullable()));
            }
            schemaChanges.add(SchemaChange.updateColumnType(modify.getOldColumn().getName(), LogicalTypeConversion.toDataType(newColumnType)));
            return schemaChanges;
        }
        if (change instanceof TableChange.ModifyColumnPosition) {
            TableChange.ModifyColumnPosition modify = (TableChange.ModifyColumnPosition)change;
            SchemaChange.Move move = this.getMove(modify.getNewPosition(), modify.getNewColumn().getName());
            schemaChanges.add(SchemaChange.updateColumnPosition(move));
            return schemaChanges;
        }
        if (change instanceof TableChange.ModifyColumnComment) {
            TableChange.ModifyColumnComment modify = (TableChange.ModifyColumnComment)change;
            schemaChanges.add(SchemaChange.updateColumnComment(modify.getNewColumn().getName(), modify.getNewComment()));
            return schemaChanges;
        }
        if (change instanceof TableChange.ModifyWatermark) {
            TableChange.ModifyWatermark modify = (TableChange.ModifyWatermark)change;
            this.setWatermarkOptions(modify.getNewWatermark(), schemaChanges);
            return schemaChanges;
        }
        if (change instanceof TableChange.SetOption) {
            TableChange.SetOption setOption = (TableChange.SetOption)change;
            String key = setOption.getKey();
            String value = setOption.getValue();
            SchemaManager.checkAlterTablePath(key);
            schemaChanges.add(SchemaChange.setOption(key, value));
            return schemaChanges;
        }
        if (change instanceof TableChange.ResetOption) {
            TableChange.ResetOption resetOption = (TableChange.ResetOption)change;
            schemaChanges.add(SchemaChange.removeOption(resetOption.getKey()));
            return schemaChanges;
        }
        throw new UnsupportedOperationException("Change is not supported: " + change.getClass());
    }

    public void alterTable(ObjectPath tablePath, CatalogBaseTable newTable, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        if (ignoreIfNotExists && !this.tableExists(tablePath)) {
            return;
        }
        CatalogTable table = this.getTable(tablePath);
        FlinkCatalog.validateAlterTable(table, (CatalogTable)newTable);
        ArrayList<SchemaChange> changes = new ArrayList<SchemaChange>();
        Map oldProperties = table.getOptions();
        for (Map.Entry entry : newTable.getOptions().entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (Objects.equals(value, oldProperties.get(key))) continue;
            if (CoreOptions.PATH.key().equalsIgnoreCase(key)) {
                throw new IllegalArgumentException("Illegal table path in table options: " + value);
            }
            changes.add(SchemaChange.setOption(key, value));
        }
        oldProperties.keySet().forEach(k -> {
            if (!newTable.getOptions().containsKey(k)) {
                changes.add(SchemaChange.removeOption(k));
            }
        });
        try {
            this.catalog.alterTable(FlinkCatalog.toIdentifier(tablePath), changes, ignoreIfNotExists);
        }
        catch (Catalog.TableNotExistException e) {
            throw new TableNotExistException(this.getName(), tablePath);
        }
        catch (Catalog.ColumnAlreadyExistException | Catalog.ColumnNotExistException e) {
            throw new CatalogException((Throwable)e);
        }
    }

    public void alterTable(ObjectPath tablePath, CatalogBaseTable newTable, List<TableChange> tableChanges, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        if (ignoreIfNotExists && !this.tableExists(tablePath)) {
            return;
        }
        CatalogTable table = this.getTable(tablePath);
        FlinkCatalog.validateAlterTable(table, (CatalogTable)newTable);
        ArrayList<SchemaChange> changes = new ArrayList<SchemaChange>();
        if (null != tableChanges) {
            List schemaChanges = tableChanges.stream().flatMap(tableChange -> this.toSchemaChange((TableChange)tableChange).stream()).collect(Collectors.toList());
            changes.addAll(schemaChanges);
        }
        try {
            this.catalog.alterTable(FlinkCatalog.toIdentifier(tablePath), changes, ignoreIfNotExists);
        }
        catch (Catalog.ColumnAlreadyExistException | Catalog.ColumnNotExistException | Catalog.TableNotExistException e) {
            throw new TableNotExistException(this.getName(), tablePath);
        }
    }

    private SchemaChange.Move getMove(TableChange.ColumnPosition columnPosition, String fieldName) {
        SchemaChange.Move move = null;
        if (columnPosition instanceof TableChange.First) {
            move = SchemaChange.Move.first(fieldName);
        } else if (columnPosition instanceof TableChange.After) {
            move = SchemaChange.Move.after(fieldName, ((TableChange.After)columnPosition).column());
        }
        return move;
    }

    private String getWatermarkKeyPrefix() {
        return FlinkCatalogPropertiesUtil.compoundKey("schema", "watermark", 0);
    }

    private String getWatermarkRowTimeKey(String watermarkPrefix) {
        return FlinkCatalogPropertiesUtil.compoundKey(watermarkPrefix, "rowtime");
    }

    private String getWatermarkExprKey(String watermarkPrefix) {
        return FlinkCatalogPropertiesUtil.compoundKey(watermarkPrefix, "strategy.expr");
    }

    private String getWatermarkExprDataTypeKey(String watermarkPrefix) {
        return FlinkCatalogPropertiesUtil.compoundKey(watermarkPrefix, "strategy.data-type");
    }

    private void setWatermarkOptions(org.apache.flink.table.catalog.WatermarkSpec wms, List<SchemaChange> schemaChanges) {
        String watermarkPrefix = this.getWatermarkKeyPrefix();
        schemaChanges.add(SchemaChange.setOption(this.getWatermarkRowTimeKey(watermarkPrefix), wms.getRowtimeAttribute()));
        schemaChanges.add(SchemaChange.setOption(this.getWatermarkExprKey(watermarkPrefix), wms.getWatermarkExpression().asSerializableString()));
        schemaChanges.add(SchemaChange.setOption(this.getWatermarkExprDataTypeKey(watermarkPrefix), wms.getWatermarkExpression().getOutputDataType().getLogicalType().asSerializableString()));
    }

    private static void validateAlterTable(CatalogTable ct1, CatalogTable ct2) {
        if (ct1 instanceof SystemCatalogTable) {
            throw new UnsupportedOperationException("Can't alter system table.");
        }
        TableSchema ts1 = ct1.getSchema();
        TableSchema ts2 = ct2.getSchema();
        boolean pkEquality = false;
        if (ts1.getPrimaryKey().isPresent() && ts2.getPrimaryKey().isPresent()) {
            pkEquality = Objects.equals(((UniqueConstraint)ts1.getPrimaryKey().get()).getType(), ((UniqueConstraint)ts2.getPrimaryKey().get()).getType()) && Objects.equals(((UniqueConstraint)ts1.getPrimaryKey().get()).getColumns(), ((UniqueConstraint)ts2.getPrimaryKey().get()).getColumns());
        } else if (!ts1.getPrimaryKey().isPresent() && !ts2.getPrimaryKey().isPresent()) {
            pkEquality = true;
        }
        if (!pkEquality) {
            throw new UnsupportedOperationException("Altering primary key is not supported yet.");
        }
        if (!ct1.getPartitionKeys().equals(ct2.getPartitionKeys())) {
            throw new UnsupportedOperationException("Altering partition keys is not supported yet.");
        }
    }

    public final void open() throws CatalogException {
    }

    public final void close() throws CatalogException {
        try {
            this.catalog.close();
        }
        catch (Exception e) {
            throw new CatalogException("Failed to close catalog " + this.catalog.toString(), (Throwable)e);
        }
    }

    private CatalogTableImpl toCatalogTable(Table table) {
        HashMap<String, String> newOptions = new HashMap<String, String>(table.options());
        TableSchema.Builder builder = TableSchema.builder();
        List physicalRowFields = LogicalTypeConversion.toLogicalType(table.rowType()).getFields();
        List<String> physicalColumns = table.rowType().getFieldNames();
        int columnCount = physicalRowFields.size() + FlinkCatalogPropertiesUtil.nonPhysicalColumnsCount(newOptions, physicalColumns);
        int physicalColumnIndex = 0;
        for (int i = 0; i < columnCount; ++i) {
            String optionalName = (String)newOptions.get(FlinkCatalogPropertiesUtil.compoundKey("schema", i, "name"));
            if (optionalName == null || physicalColumns.contains(optionalName)) {
                RowType.RowField field = (RowType.RowField)physicalRowFields.get(physicalColumnIndex++);
                builder.field(field.getName(), TypeConversions.fromLogicalToDataType((LogicalType)field.getType()));
                continue;
            }
            builder.add(FlinkCatalogPropertiesUtil.deserializeNonPhysicalColumn(newOptions, i));
        }
        if (newOptions.keySet().stream().anyMatch(key -> key.startsWith(FlinkCatalogPropertiesUtil.compoundKey("schema", "watermark")))) {
            builder.watermark(FlinkCatalogPropertiesUtil.deserializeWatermarkSpec(newOptions));
        }
        if (table.primaryKeys().size() > 0) {
            builder.primaryKey(table.primaryKeys().toArray(new String[0]));
        }
        TableSchema schema = builder.build();
        DescriptorProperties removeProperties = new DescriptorProperties(false);
        removeProperties.putTableSchema("schema", schema);
        removeProperties.asMap().keySet().forEach(newOptions::remove);
        return new DataCatalogTable(table, schema, table.partitionKeys(), newOptions, table.comment().orElse(""));
    }

    public static Schema fromCatalogTable(CatalogTable catalogTable) {
        TableSchema schema = catalogTable.getSchema();
        RowType rowType = (RowType)schema.toPhysicalRowDataType().getLogicalType();
        HashMap<String, String> options = new HashMap<String, String>(catalogTable.getOptions());
        options.putAll(FlinkCatalog.columnOptions(schema));
        Schema.Builder schemaBuilder = Schema.newBuilder().comment(catalogTable.getComment()).options(options).primaryKey(schema.getPrimaryKey().map(pk -> pk.getColumns()).orElse(Collections.emptyList())).partitionKeys(catalogTable.getPartitionKeys());
        Map<String, String> columnComments = FlinkCatalog.getColumnComments(catalogTable);
        rowType.getFields().forEach(field -> schemaBuilder.column(field.getName(), LogicalTypeConversion.toDataType(field.getType()), (String)columnComments.get(field.getName())));
        return schemaBuilder.build();
    }

    private static Map<String, String> getColumnComments(CatalogTable catalogTable) {
        return catalogTable.getUnresolvedSchema().getColumns().stream().filter(c -> c.getComment().isPresent()).collect(Collectors.toMap(Schema.UnresolvedColumn::getName, c -> (String)c.getComment().get()));
    }

    private static Map<String, String> columnOptions(TableSchema schema) {
        List watermarkSpecs;
        HashMap<String, String> columnOptions = new HashMap<String, String>();
        HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
        List tableColumns = schema.getTableColumns();
        for (int i = 0; i < tableColumns.size(); ++i) {
            indexMap.put(((TableColumn)tableColumns.get(i)).getName(), i);
        }
        List<TableColumn> nonPhysicalColumns = tableColumns.stream().filter(c -> !c.isPhysical()).collect(Collectors.toList());
        if (!nonPhysicalColumns.isEmpty()) {
            columnOptions.putAll(FlinkCatalogPropertiesUtil.serializeNonPhysicalColumns(indexMap, nonPhysicalColumns));
        }
        if (!(watermarkSpecs = schema.getWatermarkSpecs()).isEmpty()) {
            Preconditions.checkArgument(watermarkSpecs.size() == 1);
            columnOptions.putAll(FlinkCatalogPropertiesUtil.serializeWatermarkSpec((WatermarkSpec)watermarkSpecs.get(0)));
        }
        return columnOptions;
    }

    public static Identifier toIdentifier(ObjectPath path) {
        return new Identifier(path.getDatabaseName(), path.getObjectName());
    }

    public final void alterDatabase(String name, CatalogDatabase newDatabase, boolean ignoreIfNotExists) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public final void renameTable(ObjectPath tablePath, String newTableName, boolean ignoreIfNotExists) throws CatalogException, TableNotExistException, TableAlreadyExistException {
        ObjectPath toTable = new ObjectPath(tablePath.getDatabaseName(), newTableName);
        try {
            this.catalog.renameTable(FlinkCatalog.toIdentifier(tablePath), FlinkCatalog.toIdentifier(toTable), ignoreIfNotExists);
        }
        catch (Catalog.TableNotExistException e) {
            throw new TableNotExistException(this.getName(), tablePath);
        }
        catch (Catalog.TableAlreadyExistException e) {
            throw new TableAlreadyExistException(this.getName(), toTable);
        }
    }

    public final List<String> listViews(String databaseName) throws CatalogException {
        return Collections.emptyList();
    }

    public final List<CatalogPartitionSpec> listPartitions(ObjectPath tablePath) throws CatalogException {
        return Collections.emptyList();
    }

    public final List<CatalogPartitionSpec> listPartitions(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws CatalogException {
        return Collections.emptyList();
    }

    public final List<CatalogPartitionSpec> listPartitionsByFilter(ObjectPath tablePath, List<Expression> filters) throws CatalogException {
        return Collections.emptyList();
    }

    public final CatalogPartition getPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws PartitionNotExistException, CatalogException {
        throw new PartitionNotExistException(this.getName(), tablePath, partitionSpec);
    }

    public final boolean partitionExists(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws CatalogException {
        return false;
    }

    public final void createPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogPartition partition, boolean ignoreIfExists) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public final void dropPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, boolean ignoreIfNotExists) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public final void alterPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogPartition newPartition, boolean ignoreIfNotExists) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public final List<String> listFunctions(String dbName) throws CatalogException {
        return Collections.emptyList();
    }

    public final CatalogFunction getFunction(ObjectPath functionPath) throws FunctionNotExistException, CatalogException {
        throw new FunctionNotExistException(this.getName(), functionPath);
    }

    public final boolean functionExists(ObjectPath functionPath) throws CatalogException {
        return false;
    }

    public final void createFunction(ObjectPath functionPath, CatalogFunction function, boolean ignoreIfExists) throws CatalogException {
        throw new UnsupportedOperationException("Create function is not supported, maybe you can use 'CREATE TEMPORARY FUNCTION' instead.");
    }

    public final void alterFunction(ObjectPath functionPath, CatalogFunction newFunction, boolean ignoreIfNotExists) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public final void dropFunction(ObjectPath functionPath, boolean ignoreIfNotExists) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public final CatalogTableStatistics getTableStatistics(ObjectPath tablePath) throws CatalogException {
        return CatalogTableStatistics.UNKNOWN;
    }

    public final CatalogColumnStatistics getTableColumnStatistics(ObjectPath tablePath) throws CatalogException {
        return CatalogColumnStatistics.UNKNOWN;
    }

    public final CatalogTableStatistics getPartitionStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws CatalogException {
        return CatalogTableStatistics.UNKNOWN;
    }

    public final CatalogColumnStatistics getPartitionColumnStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws CatalogException {
        return CatalogColumnStatistics.UNKNOWN;
    }

    public final void alterTableStatistics(ObjectPath tablePath, CatalogTableStatistics tableStatistics, boolean ignoreIfNotExists) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public final void alterTableColumnStatistics(ObjectPath tablePath, CatalogColumnStatistics columnStatistics, boolean ignoreIfNotExists) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public final void alterPartitionStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogTableStatistics partitionStatistics, boolean ignoreIfNotExists) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public final void alterPartitionColumnStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogColumnStatistics columnStatistics, boolean ignoreIfNotExists) throws CatalogException {
        throw new UnsupportedOperationException();
    }
}

