/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableColumn;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.constraints.UniqueConstraint;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogTableImpl;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.paimon.table.Table;
import org.apache.paimon.types.DataField;

public class DataCatalogTable
extends CatalogTableImpl {
    private final Table table;

    public DataCatalogTable(Table table, TableSchema tableSchema, List<String> partitionKeys, Map<String, String> properties, String comment) {
        super(tableSchema, partitionKeys, properties, comment);
        this.table = table;
    }

    public Table table() {
        return this.table;
    }

    public Schema getUnresolvedSchema() {
        Map<String, String> columnComments = this.table.rowType().getFields().stream().filter(dataField -> dataField.description() != null).collect(Collectors.toMap(DataField::name, DataField::description));
        return this.toSchema(this.getSchema(), columnComments);
    }

    private Schema toSchema(TableSchema tableSchema, Map<String, String> comments) {
        Schema.Builder builder = Schema.newBuilder();
        tableSchema.getTableColumns().forEach(column -> {
            TableColumn.PhysicalColumn c;
            if (column instanceof TableColumn.PhysicalColumn) {
                c = (TableColumn.PhysicalColumn)column;
                builder.column(c.getName(), (AbstractDataType)c.getType());
            } else if (column instanceof TableColumn.MetadataColumn) {
                c = (TableColumn.MetadataColumn)column;
                builder.columnByMetadata(c.getName(), (AbstractDataType)c.getType(), (String)c.getMetadataAlias().orElse(null), c.isVirtual());
            } else if (column instanceof TableColumn.ComputedColumn) {
                c = (TableColumn.ComputedColumn)column;
                builder.columnByExpression(c.getName(), c.getExpression());
            } else {
                throw new IllegalArgumentException("Unsupported column type: " + column);
            }
            String colName = column.getName();
            if (comments.containsKey(colName)) {
                builder.withComment((String)comments.get(colName));
            }
        });
        tableSchema.getWatermarkSpecs().forEach(spec -> builder.watermark(spec.getRowtimeAttribute(), spec.getWatermarkExpr()));
        if (tableSchema.getPrimaryKey().isPresent()) {
            UniqueConstraint primaryKey = (UniqueConstraint)tableSchema.getPrimaryKey().get();
            builder.primaryKeyNamed(primaryKey.getName(), primaryKey.getColumns());
        }
        return builder.build();
    }

    public CatalogBaseTable copy() {
        return new DataCatalogTable(this.table, this.getSchema().copy(), new ArrayList<String>(this.getPartitionKeys()), new HashMap<String, String>(this.getOptions()), this.getComment());
    }

    public CatalogTable copy(Map<String, String> options) {
        return new DataCatalogTable(this.table, this.getSchema(), this.getPartitionKeys(), options, this.getComment());
    }
}

