/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.data.columnar.heap;

import org.apache.paimon.data.InternalMap;
import org.apache.paimon.data.columnar.ColumnVector;
import org.apache.paimon.data.columnar.ColumnarMap;
import org.apache.paimon.data.columnar.MapColumnVector;
import org.apache.paimon.data.columnar.heap.AbstractHeapVector;
import org.apache.paimon.data.columnar.writable.WritableColumnVector;

public class HeapMapVector
extends AbstractHeapVector
implements WritableColumnVector,
MapColumnVector {
    private long[] offsets;
    private long[] lengths;
    private int size;
    private ColumnVector keys;
    private ColumnVector values;

    public HeapMapVector(int len, ColumnVector keys, ColumnVector values) {
        super(len);
        this.offsets = new long[len];
        this.lengths = new long[len];
        this.keys = keys;
        this.values = values;
    }

    public void setOffsets(long[] offsets) {
        this.offsets = offsets;
    }

    public void setLengths(long[] lengths) {
        this.lengths = lengths;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setKeys(ColumnVector keys) {
        this.keys = keys;
    }

    public void setValues(ColumnVector values) {
        this.values = values;
    }

    @Override
    public InternalMap getMap(int i) {
        long offset = this.offsets[i];
        long length = this.lengths[i];
        return new ColumnarMap(this.keys, this.values, (int)offset, (int)length);
    }
}

