/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.testutils;

import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.model.DeleteMessageBatchRequest;
import com.amazonaws.services.sqs.model.DeleteMessageBatchResult;
import com.amazonaws.services.sqs.model.GetQueueAttributesRequest;
import com.amazonaws.services.sqs.model.GetQueueAttributesResult;
import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.services.sqs.model.ReceiveMessageResult;
import java.util.ArrayList;
import org.apache.hadoop.fs.Path;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class CloudObjectTestUtils {
    public static void setMessagesInQueue(AmazonSQS sqs, Path path) {
        ReceiveMessageResult receiveMessageResult = new ReceiveMessageResult();
        String approximateNumberOfMessages = "0";
        if (path != null) {
            String body = "{\n  \"Type\" : \"Notification\",\n  \"MessageId\" : \"1\",\n  \"TopicArn\" : \"arn:aws:sns:foo:123:foo-bar\",\n  \"Subject\" : \"Amazon S3 Notification\",\n  \"Message\" : \"{\\\"Records\\\":[{\\\"eventVersion\\\":\\\"2.1\\\",\\\"eventSource\\\":\\\"aws:s3\\\",\\\"awsRegion\\\":\\\"us-west-2\\\",\\\"eventTime\\\":\\\"2021-07-27T09:05:36.755Z\\\",\\\"eventName\\\":\\\"ObjectCreated:Copy\\\",\\\"userIdentity\\\":{\\\"principalId\\\":\\\"AWS:test\\\"},\\\"requestParameters\\\":{\\\"sourceIPAddress\\\":\\\"0.0.0.0\\\"},\\\"responseElements\\\":{\\\"x-amz-request-id\\\":\\\"test\\\",\\\"x-amz-id-2\\\":\\\"foobar\\\"},\\\"s3\\\":{\\\"s3SchemaVersion\\\":\\\"1.0\\\",\\\"configurationId\\\":\\\"foobar\\\",\\\"bucket\\\":{\\\"name\\\":\\\"" + path.getParent().toString().replace("hdfs://", "") + "\\\",\\\"ownerIdentity\\\":{\\\"principalId\\\":\\\"foo\\\"},\\\"arn\\\":\\\"arn:aws:s3:::foo\\\"},\\\"object\\\":{\\\"key\\\":\\\"" + path.getName() + "\\\",\\\"size\\\":123,\\\"eTag\\\":\\\"test\\\",\\\"sequencer\\\":\\\"1\\\"}}}]}\"}";
            Message message = new Message();
            message.setReceiptHandle("1");
            message.setMessageId("1");
            message.setBody(body);
            ArrayList<Message> messages = new ArrayList<Message>();
            messages.add(message);
            receiveMessageResult.setMessages(messages);
            approximateNumberOfMessages = "1";
        }
        Mockito.when((Object)sqs.receiveMessage((ReceiveMessageRequest)ArgumentMatchers.any(ReceiveMessageRequest.class))).thenReturn((Object)receiveMessageResult);
        Mockito.when((Object)sqs.getQueueAttributes((GetQueueAttributesRequest)ArgumentMatchers.any(GetQueueAttributesRequest.class))).thenReturn((Object)new GetQueueAttributesResult().addAttributesEntry("ApproximateNumberOfMessages", approximateNumberOfMessages));
    }

    public static void deleteMessagesInQueue(AmazonSQS sqs) {
        Mockito.when((Object)sqs.deleteMessageBatch((DeleteMessageBatchRequest)ArgumentMatchers.any(DeleteMessageBatchRequest.class))).thenReturn((Object)new DeleteMessageBatchResult());
    }
}

