/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources.helpers;

import com.google.protobuf.BoolValue;
import com.google.protobuf.ByteString;
import com.google.protobuf.BytesValue;
import com.google.protobuf.DoubleValue;
import com.google.protobuf.FloatValue;
import com.google.protobuf.Int32Value;
import com.google.protobuf.Int64Value;
import com.google.protobuf.Message;
import com.google.protobuf.StringValue;
import com.google.protobuf.Timestamp;
import com.google.protobuf.UInt32Value;
import com.google.protobuf.UInt64Value;
import com.google.protobuf.util.Timestamps;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.avro.Conversions;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.utilities.sources.helpers.ProtoConversionUtil;
import org.apache.hudi.utilities.test.proto.Child;
import org.apache.hudi.utilities.test.proto.Nested;
import org.apache.hudi.utilities.test.proto.Parent;
import org.apache.hudi.utilities.test.proto.Sample;
import org.apache.hudi.utilities.test.proto.SampleEnum;
import org.apache.hudi.utilities.test.proto.WithOneOf;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestProtoConversionUtil {
    private static final Random RANDOM = new Random();
    private static final String MAX_UNSIGNED_LONG = "18446744073709551615";
    private static final String PRIMITIVE_UNSIGNED_LONG_FIELD_NAME = "primitive_unsigned_long";
    private static final String WRAPPED_UNSIGNED_LONG_FIELD_NAME = "wrapped_unsigned_long";
    private static final Conversions.DecimalConversion DECIMAL_CONVERSION = new Conversions.DecimalConversion();

    @Test
    public void allFieldsSet_wellKnownTypesAndTimestampsAsRecords() throws IOException {
        Schema.Parser parser = new Schema.Parser();
        Schema convertedSchema = parser.parse(this.getClass().getClassLoader().getResourceAsStream("schema-provider/proto/sample_schema_wrapped_and_timestamp_as_record.avsc"));
        Pair<Sample, GenericRecord> inputAndOutput = this.createInputOutputSampleWithRandomValues(convertedSchema, true);
        Sample input = (Sample)inputAndOutput.getLeft();
        GenericRecord actual = this.serializeAndDeserializeAvro(ProtoConversionUtil.convertToAvro((Schema)convertedSchema, (Message)input), convertedSchema);
        Assertions.assertEquals((Object)inputAndOutput.getRight(), (Object)actual);
        Schema primitiveUnsignedLongSchema = convertedSchema.getField(PRIMITIVE_UNSIGNED_LONG_FIELD_NAME).schema();
        this.assertUnsignedLongCorrectness(primitiveUnsignedLongSchema, input.getPrimitiveUnsignedLong(), (GenericFixed)actual.get(PRIMITIVE_UNSIGNED_LONG_FIELD_NAME));
        Schema wrappedUnsignedLongSchema = ((Schema)convertedSchema.getField(WRAPPED_UNSIGNED_LONG_FIELD_NAME).schema().getTypes().get(1)).getField("value").schema();
        this.assertUnsignedLongCorrectness(wrappedUnsignedLongSchema, input.getWrappedUnsignedLong().getValue(), (GenericFixed)((GenericRecord)actual.get(WRAPPED_UNSIGNED_LONG_FIELD_NAME)).get("value"));
    }

    @Test
    public void noFieldsSet_wellKnownTypesAndTimestampsAsRecords() throws IOException {
        Sample sample = Sample.newBuilder().build();
        Schema.Parser parser = new Schema.Parser();
        Schema convertedSchema = parser.parse(this.getClass().getClassLoader().getResourceAsStream("schema-provider/proto/sample_schema_wrapped_and_timestamp_as_record.avsc"));
        GenericRecord actual = this.serializeAndDeserializeAvro(ProtoConversionUtil.convertToAvro((Schema)convertedSchema, (Message)sample), convertedSchema);
        Assertions.assertEquals((Object)this.createDefaultOutput(convertedSchema), (Object)actual);
    }

    @Test
    public void allFieldsSet_defaultOptions() throws IOException {
        Schema.Parser parser = new Schema.Parser();
        Schema convertedSchema = parser.parse(this.getClass().getClassLoader().getResourceAsStream("schema-provider/proto/sample_schema_defaults.avsc"));
        Pair<Sample, GenericRecord> inputAndOutput = this.createInputOutputSampleWithRandomValues(convertedSchema, false);
        Sample input = (Sample)inputAndOutput.getLeft();
        GenericRecord actual = this.serializeAndDeserializeAvro(ProtoConversionUtil.convertToAvro((Schema)convertedSchema, (Message)input), convertedSchema);
        Assertions.assertEquals((Object)inputAndOutput.getRight(), (Object)actual);
        Schema primitiveUnsignedLongSchema = convertedSchema.getField(PRIMITIVE_UNSIGNED_LONG_FIELD_NAME).schema();
        this.assertUnsignedLongCorrectness(primitiveUnsignedLongSchema, input.getPrimitiveUnsignedLong(), (GenericFixed)actual.get(PRIMITIVE_UNSIGNED_LONG_FIELD_NAME));
        Schema wrappedUnsignedLongSchema = (Schema)convertedSchema.getField(WRAPPED_UNSIGNED_LONG_FIELD_NAME).schema().getTypes().get(1);
        this.assertUnsignedLongCorrectness(wrappedUnsignedLongSchema, input.getWrappedUnsignedLong().getValue(), (GenericFixed)actual.get(WRAPPED_UNSIGNED_LONG_FIELD_NAME));
    }

    @Test
    public void noFieldsSet_defaultOptions() throws IOException {
        Sample sample = Sample.newBuilder().build();
        Schema.Parser parser = new Schema.Parser();
        Schema convertedSchema = parser.parse(this.getClass().getClassLoader().getResourceAsStream("schema-provider/proto/sample_schema_defaults.avsc"));
        GenericRecord actual = this.serializeAndDeserializeAvro(ProtoConversionUtil.convertToAvro((Schema)convertedSchema, (Message)sample), convertedSchema);
        Assertions.assertEquals((Object)this.createDefaultOutput(convertedSchema), (Object)actual);
    }

    @Test
    public void recursiveSchema_noOverflow() throws IOException {
        Schema.Parser parser = new Schema.Parser();
        Schema convertedSchema = parser.parse(this.getClass().getClassLoader().getResourceAsStream("schema-provider/proto/parent_schema_recursive_depth_2.avsc"));
        Pair<Parent, GenericRecord> inputAndOutput = this.createInputOutputForRecursiveSchemaNoOverflow(convertedSchema);
        GenericRecord actual = this.serializeAndDeserializeAvro(ProtoConversionUtil.convertToAvro((Schema)convertedSchema, (Message)((Message)inputAndOutput.getLeft())), convertedSchema);
        Assertions.assertEquals((Object)inputAndOutput.getRight(), (Object)actual);
    }

    @Test
    public void recursiveSchema_withOverflow() throws Exception {
        Schema.Parser parser = new Schema.Parser();
        Schema convertedSchema = parser.parse(this.getClass().getClassLoader().getResourceAsStream("schema-provider/proto/parent_schema_recursive_depth_2.avsc"));
        Pair<Parent, GenericRecord> inputAndOutput = this.createInputOutputForRecursiveSchemaWithOverflow(convertedSchema);
        Parent input = (Parent)inputAndOutput.getLeft();
        GenericRecord actual = this.serializeAndDeserializeAvro(ProtoConversionUtil.convertToAvro((Schema)convertedSchema, (Message)((Message)inputAndOutput.getLeft())), convertedSchema);
        Assertions.assertEquals((Object)inputAndOutput.getRight(), (Object)actual);
        Child parsedSingleChildOverflow = Child.parseFrom(this.getOverflowBytesFromChildRecord((GenericRecord)actual.get("child")));
        Assertions.assertEquals((Object)input.getChild().getRecurseField().getRecurseField(), (Object)parsedSingleChildOverflow);
        GenericData.Array array = (GenericData.Array)actual.get("children");
        Child parsedChildren1Overflow = Child.parseFrom(this.getOverflowBytesFromChildRecord((GenericRecord)array.get(0)));
        Assertions.assertEquals((Object)input.getChildren(0).getRecurseField().getRecurseField(), (Object)parsedChildren1Overflow);
        Child parsedChildren2Overflow = Child.parseFrom(this.getOverflowBytesFromChildRecord((GenericRecord)array.get(1)));
        Assertions.assertEquals((Object)input.getChildren(1).getRecurseField().getRecurseField(), (Object)parsedChildren2Overflow);
    }

    @Test
    public void oneOfSchema() throws IOException {
        Schema.Parser parser = new Schema.Parser();
        Schema convertedSchema = parser.parse(this.getClass().getClassLoader().getResourceAsStream("schema-provider/proto/oneof_schema.avsc"));
        WithOneOf input = WithOneOf.newBuilder().setLong(32L).build();
        GenericRecord actual = this.serializeAndDeserializeAvro(ProtoConversionUtil.convertToAvro((Schema)convertedSchema, (Message)input), convertedSchema);
        GenericData.Record expectedRecord = new GenericData.Record(convertedSchema);
        expectedRecord.put("int", null);
        expectedRecord.put("long", (Object)32L);
        expectedRecord.put("message", null);
        Assertions.assertEquals((Object)expectedRecord, (Object)actual);
    }

    @Test
    public void longToUnsignedBigIntegerConversion() {
        Assertions.assertEquals((Object)"0", (Object)ProtoConversionUtil.toUnsignedBigInteger((long)0L).toString());
        Assertions.assertEquals((Object)MAX_UNSIGNED_LONG, (Object)ProtoConversionUtil.toUnsignedBigInteger((long)-1L).toString());
        Assertions.assertEquals((Object)String.valueOf(Long.MAX_VALUE), (Object)ProtoConversionUtil.toUnsignedBigInteger((long)Long.MAX_VALUE).toString());
        Assertions.assertEquals((Object)"10", (Object)ProtoConversionUtil.toUnsignedBigInteger((long)10L).toString());
        Assertions.assertEquals((Object)"12297829379609722880", (Object)ProtoConversionUtil.toUnsignedBigInteger((long)-6148914694099828736L).toString());
    }

    private void assertUnsignedLongCorrectness(Schema fieldSchema, long expectedValue, GenericFixed actual) {
        BigDecimal actualPrimitiveUnsignedLong = DECIMAL_CONVERSION.fromFixed(actual, fieldSchema, fieldSchema.getLogicalType());
        Assertions.assertEquals((Object)Long.toUnsignedString(expectedValue), (Object)actualPrimitiveUnsignedLong.toString());
    }

    private Pair<Sample, GenericRecord> createInputOutputSampleWithRandomValues(Schema schema, boolean wellKnownTypesAsRecords) {
        Long timestampOutput;
        ByteBuffer wrappedBytesOutput;
        Boolean wrappedBooleanOutput;
        Float wrappedFloatOutput;
        Double wrappedDoubleOutput;
        GenericFixed wrappedULongOutput;
        Long wrappedUIntOutput;
        Long wrappedLongOutput;
        Integer wrappedIntOutput;
        String wrappedStringOutput;
        Schema nestedMessageSchema = (Schema)schema.getField("nested_message").schema().getTypes().get(1);
        Schema listMessageSchema = schema.getField("repeated_message").schema().getElementType();
        Schema mapMessageSchema = (Schema)schema.getField("map_message").schema().getElementType().getField("value").schema().getTypes().get(1);
        Schema unsignedLongSchema = schema.getField(PRIMITIVE_UNSIGNED_LONG_FIELD_NAME).schema();
        boolean primitiveUnsignedLongInUnsignedRange = RANDOM.nextBoolean();
        double primitiveDouble = RANDOM.nextDouble();
        float primitiveFloat = RANDOM.nextFloat();
        int primitiveInt = RANDOM.nextInt();
        long primitiveLong = RANDOM.nextLong();
        int primitiveUnsignedInt = RANDOM.nextInt();
        long primitiveUnsignedLong = RANDOM.nextLong();
        int primitiveSignedInt = RANDOM.nextInt();
        long primitiveSignedLong = RANDOM.nextLong();
        int primitiveFixedInt = RANDOM.nextInt();
        long primitiveFixedLong = primitiveUnsignedLongInUnsignedRange ? Long.parseUnsignedLong(MAX_UNSIGNED_LONG) - (long)RANDOM.nextInt(1000) : RANDOM.nextLong();
        int primitiveFixedSignedInt = RANDOM.nextInt();
        long primitiveFixedSignedLong = RANDOM.nextLong();
        boolean primitiveBoolean = RANDOM.nextBoolean();
        String primitiveString = TestProtoConversionUtil.randomString(10);
        byte[] primitiveBytes = TestProtoConversionUtil.randomString(10).getBytes();
        double wrappedDouble = RANDOM.nextDouble();
        float wrappedFloat = RANDOM.nextFloat();
        int wrappedInt = RANDOM.nextInt();
        long wrappedLong = RANDOM.nextLong();
        int wrappedUnsignedInt = RANDOM.nextInt();
        long wrappedUnsignedLong = primitiveUnsignedLongInUnsignedRange ? RANDOM.nextLong() : Long.parseUnsignedLong(MAX_UNSIGNED_LONG) - (long)RANDOM.nextInt(1000);
        boolean wrappedBoolean = RANDOM.nextBoolean();
        String wrappedString = TestProtoConversionUtil.randomString(10);
        byte[] wrappedBytes = TestProtoConversionUtil.randomString(10).getBytes();
        SampleEnum enumValue = SampleEnum.forNumber(RANDOM.nextInt(1));
        List<Integer> primitiveList = Arrays.asList(RANDOM.nextInt(), RANDOM.nextInt(), RANDOM.nextInt());
        HashMap<String, Integer> primitiveMap = new HashMap<String, Integer>();
        primitiveMap.put(TestProtoConversionUtil.randomString(5), RANDOM.nextInt());
        primitiveMap.put(TestProtoConversionUtil.randomString(5), RANDOM.nextInt());
        Nested nestedMessage = Nested.newBuilder().setNestedInt(RANDOM.nextInt()).build();
        List<Nested> nestedList = Arrays.asList(Nested.newBuilder().setNestedInt(RANDOM.nextInt()).build(), Nested.newBuilder().setNestedInt(RANDOM.nextInt()).build());
        HashMap<String, Nested> nestedMap = new HashMap<String, Nested>();
        nestedMap.put(TestProtoConversionUtil.randomString(5), Nested.newBuilder().setNestedInt(RANDOM.nextInt()).build());
        nestedMap.put(TestProtoConversionUtil.randomString(5), Nested.newBuilder().setNestedInt(RANDOM.nextInt()).build());
        Timestamp time = Timestamps.fromMillis((long)System.currentTimeMillis());
        Sample input = Sample.newBuilder().setPrimitiveDouble(primitiveDouble).setPrimitiveFloat(primitiveFloat).setPrimitiveInt(primitiveInt).setPrimitiveLong(primitiveLong).setPrimitiveUnsignedInt(primitiveUnsignedInt).setPrimitiveUnsignedLong(primitiveUnsignedLong).setPrimitiveSignedInt(primitiveSignedInt).setPrimitiveSignedLong(primitiveSignedLong).setPrimitiveFixedInt(primitiveFixedInt).setPrimitiveFixedLong(primitiveFixedLong).setPrimitiveFixedSignedInt(primitiveFixedSignedInt).setPrimitiveFixedSignedLong(primitiveFixedSignedLong).setPrimitiveBoolean(primitiveBoolean).setPrimitiveString(primitiveString).setPrimitiveBytes(ByteString.copyFrom((byte[])primitiveBytes)).addAllRepeatedPrimitive(primitiveList).putAllMapPrimitive(primitiveMap).setNestedMessage(nestedMessage).addAllRepeatedMessage(nestedList).putAllMapMessage(nestedMap).setWrappedString(StringValue.of((String)wrappedString)).setWrappedInt(Int32Value.of((int)wrappedInt)).setWrappedLong(Int64Value.of((long)wrappedLong)).setWrappedUnsignedInt(UInt32Value.of((int)wrappedUnsignedInt)).setWrappedUnsignedLong(UInt64Value.of((long)wrappedUnsignedLong)).setWrappedDouble(DoubleValue.of((double)wrappedDouble)).setWrappedFloat(FloatValue.of((float)wrappedFloat)).setWrappedBoolean(BoolValue.of((boolean)wrappedBoolean)).setWrappedBytes(BytesValue.of((ByteString)ByteString.copyFrom((byte[])wrappedBytes))).setEnum(enumValue).setTimestamp(time).build();
        if (wellKnownTypesAsRecords) {
            wrappedStringOutput = this.getWrappedRecord(schema, "wrapped_string", wrappedString);
            wrappedIntOutput = this.getWrappedRecord(schema, "wrapped_int", wrappedInt);
            wrappedLongOutput = this.getWrappedRecord(schema, "wrapped_long", wrappedLong);
            wrappedUIntOutput = this.getWrappedRecord(schema, "wrapped_unsigned_int", wrappedUnsignedInt);
            wrappedULongOutput = this.getWrappedRecord(schema, WRAPPED_UNSIGNED_LONG_FIELD_NAME, this.unsignedLongAsGenericFixed(wrappedUnsignedLong, unsignedLongSchema));
            wrappedDoubleOutput = this.getWrappedRecord(schema, "wrapped_double", wrappedDouble);
            wrappedFloatOutput = this.getWrappedRecord(schema, "wrapped_float", Float.valueOf(wrappedFloat));
            wrappedBooleanOutput = this.getWrappedRecord(schema, "wrapped_boolean", wrappedBoolean);
            wrappedBytesOutput = this.getWrappedRecord(schema, "wrapped_bytes", ByteBuffer.wrap(wrappedBytes));
            timestampOutput = this.getTimestampRecord(schema, time);
        } else {
            wrappedStringOutput = wrappedString;
            wrappedIntOutput = wrappedInt;
            wrappedLongOutput = wrappedLong;
            wrappedUIntOutput = wrappedUnsignedInt;
            wrappedULongOutput = this.unsignedLongAsGenericFixed(wrappedUnsignedLong, unsignedLongSchema);
            wrappedDoubleOutput = wrappedDouble;
            wrappedFloatOutput = Float.valueOf(wrappedFloat);
            wrappedBooleanOutput = wrappedBoolean;
            wrappedBytesOutput = ByteBuffer.wrap(wrappedBytes);
            timestampOutput = Timestamps.toMicros((Timestamp)time);
        }
        GenericData.Record expectedRecord = new GenericData.Record(schema);
        expectedRecord.put("primitive_double", (Object)primitiveDouble);
        expectedRecord.put("primitive_float", (Object)Float.valueOf(primitiveFloat));
        expectedRecord.put("primitive_int", (Object)primitiveInt);
        expectedRecord.put("primitive_long", (Object)primitiveLong);
        expectedRecord.put("primitive_unsigned_int", (Object)primitiveUnsignedInt);
        expectedRecord.put(PRIMITIVE_UNSIGNED_LONG_FIELD_NAME, (Object)this.unsignedLongAsGenericFixed(primitiveUnsignedLong, unsignedLongSchema));
        expectedRecord.put("primitive_signed_int", (Object)primitiveSignedInt);
        expectedRecord.put("primitive_signed_long", (Object)primitiveSignedLong);
        expectedRecord.put("primitive_fixed_int", (Object)primitiveFixedInt);
        expectedRecord.put("primitive_fixed_long", (Object)primitiveFixedLong);
        expectedRecord.put("primitive_fixed_signed_int", (Object)primitiveFixedSignedInt);
        expectedRecord.put("primitive_fixed_signed_long", (Object)primitiveFixedSignedLong);
        expectedRecord.put("primitive_boolean", (Object)primitiveBoolean);
        expectedRecord.put("primitive_string", (Object)primitiveString);
        expectedRecord.put("primitive_bytes", (Object)ByteBuffer.wrap(primitiveBytes));
        expectedRecord.put("repeated_primitive", primitiveList);
        expectedRecord.put("map_primitive", TestProtoConversionUtil.convertMapToList(schema, "map_primitive", primitiveMap));
        expectedRecord.put("nested_message", (Object)this.convertNestedMessage(nestedMessageSchema, nestedMessage));
        expectedRecord.put("repeated_message", nestedList.stream().map(m -> this.convertNestedMessage(listMessageSchema, (Nested)m)).collect(Collectors.toList()));
        expectedRecord.put("map_message", TestProtoConversionUtil.convertMapToList(schema, "map_message", nestedMap, value -> this.convertNestedMessage(mapMessageSchema, (Nested)value)));
        expectedRecord.put("wrapped_string", (Object)wrappedStringOutput);
        expectedRecord.put("wrapped_int", (Object)wrappedIntOutput);
        expectedRecord.put("wrapped_long", (Object)wrappedLongOutput);
        expectedRecord.put("wrapped_unsigned_int", (Object)wrappedUIntOutput);
        expectedRecord.put(WRAPPED_UNSIGNED_LONG_FIELD_NAME, (Object)wrappedULongOutput);
        expectedRecord.put("wrapped_double", (Object)wrappedDoubleOutput);
        expectedRecord.put("wrapped_float", (Object)wrappedFloatOutput);
        expectedRecord.put("wrapped_boolean", (Object)wrappedBooleanOutput);
        expectedRecord.put("wrapped_bytes", (Object)wrappedBytesOutput);
        expectedRecord.put("enum", (Object)enumValue.name());
        expectedRecord.put("timestamp", (Object)timestampOutput);
        return Pair.of((Object)input, (Object)expectedRecord);
    }

    private GenericFixed unsignedLongAsGenericFixed(long unsignedLong, Schema unsignedLongSchema) {
        BigDecimal bigDecimal = new BigDecimal(ProtoConversionUtil.toUnsignedBigInteger((long)unsignedLong));
        return DECIMAL_CONVERSION.toFixed(bigDecimal, unsignedLongSchema, unsignedLongSchema.getLogicalType());
    }

    private GenericRecord createDefaultOutput(Schema schema) {
        Schema unsignedLongSchema = schema.getField(PRIMITIVE_UNSIGNED_LONG_FIELD_NAME).schema();
        GenericData.Record expectedRecord = new GenericData.Record(schema);
        expectedRecord.put("primitive_double", (Object)0.0);
        expectedRecord.put("primitive_float", (Object)Float.valueOf(0.0f));
        expectedRecord.put("primitive_int", (Object)0);
        expectedRecord.put("primitive_long", (Object)0L);
        expectedRecord.put("primitive_unsigned_int", (Object)0L);
        expectedRecord.put(PRIMITIVE_UNSIGNED_LONG_FIELD_NAME, (Object)this.unsignedLongAsGenericFixed(0L, unsignedLongSchema));
        expectedRecord.put("primitive_signed_int", (Object)0);
        expectedRecord.put("primitive_signed_long", (Object)0L);
        expectedRecord.put("primitive_fixed_int", (Object)0);
        expectedRecord.put("primitive_fixed_long", (Object)0L);
        expectedRecord.put("primitive_fixed_signed_int", (Object)0);
        expectedRecord.put("primitive_fixed_signed_long", (Object)0L);
        expectedRecord.put("primitive_boolean", (Object)false);
        expectedRecord.put("primitive_string", (Object)"");
        expectedRecord.put("primitive_bytes", (Object)ByteBuffer.wrap("".getBytes()));
        expectedRecord.put("repeated_primitive", Collections.emptyList());
        expectedRecord.put("map_primitive", Collections.emptyList());
        expectedRecord.put("nested_message", null);
        expectedRecord.put("repeated_message", Collections.emptyList());
        expectedRecord.put("map_message", Collections.emptyList());
        expectedRecord.put("wrapped_string", null);
        expectedRecord.put("wrapped_int", null);
        expectedRecord.put("wrapped_long", null);
        expectedRecord.put("wrapped_unsigned_int", null);
        expectedRecord.put(WRAPPED_UNSIGNED_LONG_FIELD_NAME, null);
        expectedRecord.put("wrapped_double", null);
        expectedRecord.put("wrapped_float", null);
        expectedRecord.put("wrapped_boolean", null);
        expectedRecord.put("wrapped_bytes", null);
        expectedRecord.put("enum", (Object)SampleEnum.FIRST.name());
        expectedRecord.put("timestamp", null);
        return expectedRecord;
    }

    public Pair<Parent, GenericRecord> createInputOutputForRecursiveSchemaNoOverflow(Schema schema) {
        Child singleChild = Child.newBuilder().setBasicField(1).setRecurseField(Child.newBuilder().setBasicField(2).build()).build();
        Child children1 = Child.newBuilder().setBasicField(11).setRecurseField(Child.newBuilder().setBasicField(12).build()).build();
        Child children2 = Child.newBuilder().setBasicField(21).setRecurseField(Child.newBuilder().setBasicField(22).build()).build();
        List<Child> childrenList = Arrays.asList(children1, children2);
        Parent input = Parent.newBuilder().setChild(singleChild).addAllChildren(childrenList).build();
        Schema childAvroSchema = (Schema)schema.getField("child").schema().getTypes().get(1);
        Schema childLevel2AvroSchema = (Schema)childAvroSchema.getField("recurse_field").schema().getTypes().get(1);
        Schema childrenAvroSchema = schema.getField("children").schema().getElementType();
        Schema childrenLevel2AvroSchema = (Schema)childrenAvroSchema.getField("recurse_field").schema().getTypes().get(1);
        GenericData.Record singleChildLevel2Avro = new GenericData.Record(childLevel2AvroSchema);
        singleChildLevel2Avro.put("basic_field", (Object)2);
        GenericData.Record singleChildAvro = new GenericData.Record(childAvroSchema);
        singleChildAvro.put("basic_field", (Object)1);
        singleChildAvro.put("recurse_field", (Object)singleChildLevel2Avro);
        GenericData.Record children1Level2Avro = new GenericData.Record(childrenLevel2AvroSchema);
        children1Level2Avro.put("basic_field", (Object)12);
        GenericData.Record children1Avro = new GenericData.Record(childrenAvroSchema);
        children1Avro.put("basic_field", (Object)11);
        children1Avro.put("recurse_field", (Object)children1Level2Avro);
        GenericData.Record children2Level2Avro = new GenericData.Record(childrenLevel2AvroSchema);
        children2Level2Avro.put("basic_field", (Object)22);
        GenericData.Record children2Avro = new GenericData.Record(childrenAvroSchema);
        children2Avro.put("basic_field", (Object)21);
        children2Avro.put("recurse_field", (Object)children2Level2Avro);
        GenericData.Record expected = new GenericData.Record(schema);
        expected.put("child", (Object)singleChildAvro);
        expected.put("children", Arrays.asList(children1Avro, children2Avro));
        return Pair.of((Object)input, (Object)expected);
    }

    public Pair<Parent, GenericRecord> createInputOutputForRecursiveSchemaWithOverflow(Schema schema) {
        Child singleChildOverflow = Child.newBuilder().setBasicField(3).setRecurseField(Child.newBuilder().setBasicField(4).build()).build();
        Child singleChild = Child.newBuilder().setBasicField(1).setRecurseField(Child.newBuilder().setBasicField(2).setRecurseField(singleChildOverflow).build()).build();
        Child children1Overflow = Child.newBuilder().setBasicField(13).setRecurseField(Child.newBuilder().setBasicField(14).build()).build();
        Child children1 = Child.newBuilder().setBasicField(11).setRecurseField(Child.newBuilder().setBasicField(12).setRecurseField(children1Overflow).build()).build();
        Child children2Overflow = Child.newBuilder().setBasicField(23).setRecurseField(Child.newBuilder().setBasicField(24).build()).build();
        Child children2 = Child.newBuilder().setBasicField(21).setRecurseField(Child.newBuilder().setBasicField(22).setRecurseField(children2Overflow).build()).build();
        List<Child> childrenList = Arrays.asList(children1, children2);
        Parent input = Parent.newBuilder().setChild(singleChild).addAllChildren(childrenList).build();
        Schema childAvroSchema = (Schema)schema.getField("child").schema().getTypes().get(1);
        Schema childLevel2AvroSchema = (Schema)childAvroSchema.getField("recurse_field").schema().getTypes().get(1);
        Schema recursionOverflowSchema = (Schema)childLevel2AvroSchema.getField("recurse_field").schema().getTypes().get(1);
        Schema childrenAvroSchema = schema.getField("children").schema().getElementType();
        Schema childrenLevel2AvroSchema = (Schema)childrenAvroSchema.getField("recurse_field").schema().getTypes().get(1);
        GenericData.Record singleChildOverflowAvro = new GenericData.Record(recursionOverflowSchema);
        singleChildOverflowAvro.put("descriptor_full_name", (Object)"test.Child");
        singleChildOverflowAvro.put("proto_bytes", (Object)ByteBuffer.wrap(singleChildOverflow.toByteArray()));
        GenericData.Record singleChildLevel2Avro = new GenericData.Record(childLevel2AvroSchema);
        singleChildLevel2Avro.put("basic_field", (Object)2);
        singleChildLevel2Avro.put("recurse_field", (Object)singleChildOverflowAvro);
        GenericData.Record singleChildAvro = new GenericData.Record(childAvroSchema);
        singleChildAvro.put("basic_field", (Object)1);
        singleChildAvro.put("recurse_field", (Object)singleChildLevel2Avro);
        GenericData.Record children1OverflowAvro = new GenericData.Record(recursionOverflowSchema);
        children1OverflowAvro.put("descriptor_full_name", (Object)"test.Child");
        children1OverflowAvro.put("proto_bytes", (Object)ByteBuffer.wrap(children1Overflow.toByteArray()));
        GenericData.Record children1Level2Avro = new GenericData.Record(childrenLevel2AvroSchema);
        children1Level2Avro.put("basic_field", (Object)12);
        children1Level2Avro.put("recurse_field", (Object)children1OverflowAvro);
        GenericData.Record children1Avro = new GenericData.Record(childrenAvroSchema);
        children1Avro.put("basic_field", (Object)11);
        children1Avro.put("recurse_field", (Object)children1Level2Avro);
        GenericData.Record children2OverflowAvro = new GenericData.Record(recursionOverflowSchema);
        children2OverflowAvro.put("descriptor_full_name", (Object)"test.Child");
        children2OverflowAvro.put("proto_bytes", (Object)ByteBuffer.wrap(children2Overflow.toByteArray()));
        GenericData.Record children2Level2Avro = new GenericData.Record(childrenLevel2AvroSchema);
        children2Level2Avro.put("basic_field", (Object)22);
        children2Level2Avro.put("recurse_field", (Object)children2OverflowAvro);
        GenericData.Record children2Avro = new GenericData.Record(childrenAvroSchema);
        children2Avro.put("basic_field", (Object)21);
        children2Avro.put("recurse_field", (Object)children2Level2Avro);
        GenericData.Record expected = new GenericData.Record(schema);
        expected.put("child", (Object)singleChildAvro);
        expected.put("children", Arrays.asList(children1Avro, children2Avro));
        return Pair.of((Object)input, (Object)expected);
    }

    private ByteBuffer getOverflowBytesFromChildRecord(GenericRecord record) {
        return (ByteBuffer)((GenericRecord)((GenericRecord)record.get("recurse_field")).get("recurse_field")).get("proto_bytes");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private GenericRecord serializeAndDeserializeAvro(GenericRecord input, Schema schema) {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            GenericRecord transformedRec;
            BinaryEncoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)outputStream, null);
            GenericDatumWriter writer = new GenericDatumWriter(schema);
            writer.write((Object)input, (Encoder)encoder);
            encoder.flush();
            BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(outputStream.toByteArray(), null);
            GenericDatumReader reader = new GenericDatumReader(schema);
            GenericRecord genericRecord = transformedRec = (GenericRecord)reader.read(null, (Decoder)decoder);
            return genericRecord;
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private GenericData.Record getTimestampRecord(Schema protoSchema, Timestamp time) {
        GenericData.Record timestampRecord = new GenericData.Record((Schema)protoSchema.getField("timestamp").schema().getTypes().get(1));
        timestampRecord.put("seconds", (Object)time.getSeconds());
        timestampRecord.put("nanos", (Object)time.getNanos());
        return timestampRecord;
    }

    private GenericData.Record getWrappedRecord(Schema protoSchema, String fieldName, Object value) {
        GenericData.Record wrappedRecord = new GenericData.Record((Schema)protoSchema.getField(fieldName).schema().getTypes().get(1));
        wrappedRecord.put("value", value);
        return wrappedRecord;
    }

    private GenericRecord convertNestedMessage(Schema schema, Nested message) {
        GenericData.Record record = new GenericData.Record(schema);
        record.put("nested_int", (Object)message.getNestedInt());
        return record;
    }

    private static <K, V> List<GenericRecord> convertMapToList(Schema protoSchema, String fieldName, Map<K, V> originalMap, Function<V, ?> valueConverter) {
        return originalMap.entrySet().stream().map(entry -> {
            GenericData.Record record = new GenericData.Record(protoSchema.getField(fieldName).schema().getElementType());
            record.put("key", entry.getKey());
            record.put("value", valueConverter.apply(entry.getValue()));
            return record;
        }).collect(Collectors.toList());
    }

    private static <K, V> List<GenericRecord> convertMapToList(Schema protoSchema, String fieldName, Map<K, V> originalMap) {
        return TestProtoConversionUtil.convertMapToList(protoSchema, fieldName, originalMap, Function.identity());
    }

    private static String randomString(int size) {
        byte[] bytes = new byte[size];
        RANDOM.nextBytes(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }
}

