/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources.helpers;

import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.model.Message;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.testutils.HoodieClientTestHarness;
import org.apache.hudi.utilities.sources.helpers.CloudObjectsSelector;
import org.apache.hudi.utilities.testutils.CloudObjectTestUtils;
import org.json.JSONObject;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class TestCloudObjectsSelector
extends HoodieClientTestHarness {
    static final String REGION_NAME = "us-east-1";
    TypedProperties props;
    String sqsUrl;
    @Mock
    AmazonSQS sqs;
    @Mock
    private CloudObjectsSelector cloudObjectsSelector;

    @BeforeEach
    void setUp() {
        this.initSparkContexts();
        this.initPath();
        this.initFileSystem();
        MockitoAnnotations.initMocks((Object)((Object)this));
        this.props = new TypedProperties();
        this.sqsUrl = "test-queue";
        this.props.setProperty("hoodie.deltastreamer.s3.source.queue.url", this.sqsUrl);
        this.props.setProperty("hoodie.deltastreamer.s3.source.queue.region", REGION_NAME);
    }

    @AfterEach
    public void teardown() throws Exception {
        Mockito.reset((Object[])new CloudObjectsSelector[]{this.cloudObjectsSelector});
        this.cleanupResources();
    }

    @ParameterizedTest
    @ValueSource(classes={CloudObjectsSelector.class})
    public void testSqsQueueAttributesShouldReturnsRequiredAttribute(Class<?> clazz) {
        CloudObjectsSelector selector = (CloudObjectsSelector)ReflectionUtils.loadClass((String)clazz.getName(), (Object[])new Object[]{this.props});
        CloudObjectTestUtils.setMessagesInQueue(this.sqs, null);
        Map queueAttributes = selector.getSqsQueueAttributes(this.sqs, this.sqsUrl);
        Assertions.assertEquals((int)1, (int)queueAttributes.size());
        Assertions.assertEquals((Object)"0", queueAttributes.get("ApproximateNumberOfMessages"));
    }

    @ParameterizedTest
    @ValueSource(classes={CloudObjectsSelector.class})
    public void testFileAttributesFromRecordShouldReturnsExpectOutput(Class<?> clazz) throws IOException {
        CloudObjectsSelector selector = (CloudObjectsSelector)ReflectionUtils.loadClass((String)clazz.getName(), (Object[])new Object[]{this.props});
        String bucket = "test-bucket";
        String key = "test/year=test1/month=test2/day=test3/part-foo-bar.snappy.parquet";
        String s3Records = "{\n  \"Type\" : \"Notification\",\n  \"MessageId\" : \"1\",\n  \"TopicArn\" : \"arn:aws:sns:foo:123:foo-bar\",\n  \"Subject\" : \"Amazon S3 Notification\",\n  \"Message\" : \"{\\\"Records\\\":[{\\\"eventVersion\\\":\\\"2.1\\\",\\\"eventSource\\\":\\\"aws:s3\\\",\\\"awsRegion\\\":\\\"us-west-2\\\",\\\"eventTime\\\":\\\"2021-07-27T09:05:36.755Z\\\",\\\"eventName\\\":\\\"ObjectCreated:Copy\\\",\\\"userIdentity\\\":{\\\"principalId\\\":\\\"AWS:test\\\"},\\\"requestParameters\\\":{\\\"sourceIPAddress\\\":\\\"0.0.0.0\\\"},\\\"responseElements\\\":{\\\"x-amz-request-id\\\":\\\"test\\\",\\\"x-amz-id-2\\\":\\\"foobar\\\"},\\\"s3\\\":{\\\"s3SchemaVersion\\\":\\\"1.0\\\",\\\"configurationId\\\":\\\"foobar\\\",\\\"bucket\\\":{\\\"name\\\":\\\"" + bucket + "\\\",\\\"ownerIdentity\\\":{\\\"principalId\\\":\\\"foo\\\"},\\\"arn\\\":\\\"arn:aws:s3:::foo\\\"},\\\"object\\\":{\\\"key\\\":\\\"" + key + "\\\",\\\"size\\\":123,\\\"eTag\\\":\\\"test\\\",\\\"sequencer\\\":\\\"1\\\"}}}]}\"}";
        JSONObject messageBody = new JSONObject(s3Records);
        Map messageMap = new HashMap();
        if (messageBody.has("Message")) {
            ObjectMapper mapper = new ObjectMapper();
            messageMap = (Map)mapper.readValue(messageBody.getString("Message"), Map.class);
        }
        List records = (List)messageMap.get("Records");
        Map fileAttributes = selector.getFileAttributesFromRecord(new JSONObject((Map)records.get(0)));
        Assertions.assertEquals((int)3, (int)fileAttributes.size());
        Assertions.assertEquals((long)123L, (long)((Long)fileAttributes.get("fileSize")));
        Assertions.assertEquals((Object)("s3://" + bucket + "/" + key), fileAttributes.get("filePath"));
        Assertions.assertEquals((long)1627376736755L, (long)((Long)fileAttributes.get("eventTime")));
    }

    @ParameterizedTest
    @ValueSource(classes={CloudObjectsSelector.class})
    public void testCreateListPartitionsReturnsExpectedSetOfBatch(Class<?> clazz) {
        CloudObjectsSelector selector = (CloudObjectsSelector)ReflectionUtils.loadClass((String)clazz.getName(), (Object[])new Object[]{this.props});
        ArrayList<Message> testSingleList = new ArrayList<Message>();
        testSingleList.add(new Message().addAttributesEntry("id", "1"));
        testSingleList.add(new Message().addAttributesEntry("id", "2"));
        testSingleList.add(new Message().addAttributesEntry("id", "3"));
        testSingleList.add(new Message().addAttributesEntry("id", "4"));
        testSingleList.add(new Message().addAttributesEntry("id", "5"));
        ArrayList<Message> expectedFirstList = new ArrayList<Message>();
        expectedFirstList.add(new Message().addAttributesEntry("id", "1"));
        expectedFirstList.add(new Message().addAttributesEntry("id", "2"));
        ArrayList<Message> expectedSecondList = new ArrayList<Message>();
        expectedSecondList.add(new Message().addAttributesEntry("id", "3"));
        expectedSecondList.add(new Message().addAttributesEntry("id", "4"));
        ArrayList<Message> expectedFinalList = new ArrayList<Message>();
        expectedFinalList.add(new Message().addAttributesEntry("id", "5"));
        List partitionedList = selector.createListPartitions(testSingleList, 2);
        Assertions.assertEquals((int)3, (int)partitionedList.size());
        Assertions.assertEquals(expectedFirstList, partitionedList.get(0));
        Assertions.assertEquals(expectedSecondList, partitionedList.get(1));
        Assertions.assertEquals(expectedFinalList, partitionedList.get(2));
    }

    @ParameterizedTest
    @ValueSource(classes={CloudObjectsSelector.class})
    public void testCreateListPartitionsReturnsEmptyIfBatchSizeIsZero(Class<?> clazz) {
        CloudObjectsSelector selector = (CloudObjectsSelector)ReflectionUtils.loadClass((String)clazz.getName(), (Object[])new Object[]{this.props});
        ArrayList<Message> testSingleList = new ArrayList<Message>();
        testSingleList.add(new Message().addAttributesEntry("id", "1"));
        testSingleList.add(new Message().addAttributesEntry("id", "2"));
        List partitionedList = selector.createListPartitions(testSingleList, 0);
        Assertions.assertEquals((int)0, (int)partitionedList.size());
    }

    @ParameterizedTest
    @ValueSource(classes={CloudObjectsSelector.class})
    public void testOnCommitDeleteProcessedMessages(Class<?> clazz) {
        CloudObjectsSelector selector = (CloudObjectsSelector)ReflectionUtils.loadClass((String)clazz.getName(), (Object[])new Object[]{this.props});
        ArrayList<Message> testSingleList = new ArrayList<Message>();
        testSingleList.add(new Message().addAttributesEntry("MessageId", "1").addAttributesEntry("ReceiptHandle", "1"));
        testSingleList.add(new Message().addAttributesEntry("MessageId", "2").addAttributesEntry("ReceiptHandle", "1"));
        CloudObjectTestUtils.deleteMessagesInQueue(this.sqs);
        selector.deleteProcessedMessages(this.sqs, this.sqsUrl, testSingleList);
    }
}

