/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources.helpers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.hudi.utilities.sources.helpers.KafkaOffsetGen;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.streaming.kafka010.OffsetRange;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestCheckpointUtils {
    private static final String TEST_TOPIC_NAME = "hoodie_test";

    @Test
    public void testStringToOffsets() {
        OffsetRange[] ranges = KafkaOffsetGen.CheckpointUtils.computeOffsetRanges(TestCheckpointUtils.makeOffsetMap(new int[]{0, 1}, new long[]{200000L, 250000L}), TestCheckpointUtils.makeOffsetMap(new int[]{0, 1}, new long[]{300000L, 350000L}), (long)1000000L);
        String checkpointStr = KafkaOffsetGen.CheckpointUtils.offsetsToStr((OffsetRange[])ranges);
        Map offsetMap = KafkaOffsetGen.CheckpointUtils.strToOffsets((String)checkpointStr);
        Assertions.assertEquals((int)2, (int)offsetMap.size());
        HashSet<TopicPartition> topicPartitions = new HashSet<TopicPartition>(2);
        TopicPartition partition0 = new TopicPartition(TEST_TOPIC_NAME, 0);
        TopicPartition partition1 = new TopicPartition(TEST_TOPIC_NAME, 1);
        topicPartitions.add(partition0);
        topicPartitions.add(partition1);
        Assertions.assertEquals(topicPartitions, offsetMap.keySet());
        Assertions.assertEquals((long)300000L, (Long)((Long)offsetMap.get(partition0)));
        Assertions.assertEquals((long)350000L, (Long)((Long)offsetMap.get(partition1)));
    }

    @Test
    public void testOffsetToString() {
        OffsetRange[] ranges = KafkaOffsetGen.CheckpointUtils.computeOffsetRanges(TestCheckpointUtils.makeOffsetMap(new int[]{0, 1}, new long[]{200000L, 250000L}), TestCheckpointUtils.makeOffsetMap(new int[]{0, 1}, new long[]{300000L, 350000L}), (long)1000000L);
        Assertions.assertEquals((Object)"hoodie_test,0:300000,1:350000", (Object)KafkaOffsetGen.CheckpointUtils.offsetsToStr((OffsetRange[])ranges));
    }

    @Test
    public void testComputeOffsetRanges() {
        long totalMsgs = KafkaOffsetGen.CheckpointUtils.totalNewMessages((OffsetRange[])new OffsetRange[]{OffsetRange.apply((String)TEST_TOPIC_NAME, (int)0, (long)0L, (long)100L), OffsetRange.apply((String)TEST_TOPIC_NAME, (int)0, (long)100L, (long)200L)});
        Assertions.assertEquals((long)200L, (long)totalMsgs);
        OffsetRange[] ranges = KafkaOffsetGen.CheckpointUtils.computeOffsetRanges(TestCheckpointUtils.makeOffsetMap(new int[]{0, 1}, new long[]{200000L, 250000L}), TestCheckpointUtils.makeOffsetMap(new int[]{0, 1}, new long[]{300000L, 350000L}), (long)1000000L);
        Assertions.assertEquals((long)200000L, (long)KafkaOffsetGen.CheckpointUtils.totalNewMessages((OffsetRange[])ranges));
        ranges = KafkaOffsetGen.CheckpointUtils.computeOffsetRanges(TestCheckpointUtils.makeOffsetMap(new int[]{0, 1}, new long[]{200000L, 250000L}), TestCheckpointUtils.makeOffsetMap(new int[]{0, 1}, new long[]{300000L, 350000L}), (long)10000L);
        Assertions.assertEquals((long)10000L, (long)KafkaOffsetGen.CheckpointUtils.totalNewMessages((OffsetRange[])ranges));
        Assertions.assertEquals((long)200000L, (long)ranges[0].fromOffset());
        Assertions.assertEquals((long)205000L, (long)ranges[0].untilOffset());
        Assertions.assertEquals((long)250000L, (long)ranges[1].fromOffset());
        Assertions.assertEquals((long)255000L, (long)ranges[1].untilOffset());
        ranges = KafkaOffsetGen.CheckpointUtils.computeOffsetRanges(TestCheckpointUtils.makeOffsetMap(new int[]{0, 1}, new long[]{200000L, 250000L}), TestCheckpointUtils.makeOffsetMap(new int[]{0, 1, 2}, new long[]{300000L, 350000L, 100000L}), (long)1000000L);
        Assertions.assertEquals((long)300000L, (long)KafkaOffsetGen.CheckpointUtils.totalNewMessages((OffsetRange[])ranges));
        Assertions.assertEquals((int)3, (int)ranges.length);
        ranges = KafkaOffsetGen.CheckpointUtils.computeOffsetRanges(TestCheckpointUtils.makeOffsetMap(new int[]{0, 1}, new long[]{200000L, 250000L}), TestCheckpointUtils.makeOffsetMap(new int[]{0, 1, 2}, new long[]{200010L, 350000L, 10000L}), (long)100000L);
        Assertions.assertEquals((long)100000L, (long)KafkaOffsetGen.CheckpointUtils.totalNewMessages((OffsetRange[])ranges));
        Assertions.assertEquals((long)10L, (long)ranges[0].count());
        Assertions.assertEquals((long)89990L, (long)ranges[1].count());
        Assertions.assertEquals((long)10000L, (long)ranges[2].count());
        ranges = KafkaOffsetGen.CheckpointUtils.computeOffsetRanges(TestCheckpointUtils.makeOffsetMap(new int[]{0, 1}, new long[]{200000L, 250000L}), TestCheckpointUtils.makeOffsetMap(new int[]{0, 1, 2}, new long[]{200010L, 350000L, 10000L}), (long)1000000L);
        Assertions.assertEquals((long)110010L, (long)KafkaOffsetGen.CheckpointUtils.totalNewMessages((OffsetRange[])ranges));
        Assertions.assertEquals((long)10L, (long)ranges[0].count());
        Assertions.assertEquals((long)100000L, (long)ranges[1].count());
        Assertions.assertEquals((long)10000L, (long)ranges[2].count());
        ranges = KafkaOffsetGen.CheckpointUtils.computeOffsetRanges(TestCheckpointUtils.makeOffsetMap(new int[]{0, 1, 2, 3, 4}, new long[]{0L, 0L, 0L, 0L, 0L}), TestCheckpointUtils.makeOffsetMap(new int[]{0, 1, 2, 3, 4}, new long[]{100L, 1000L, 1000L, 1000L, 1000L}), (long)1001L);
        Assertions.assertEquals((long)1001L, (long)KafkaOffsetGen.CheckpointUtils.totalNewMessages((OffsetRange[])ranges));
        Assertions.assertEquals((long)100L, (long)ranges[0].count());
        Assertions.assertEquals((long)226L, (long)ranges[1].count());
        Assertions.assertEquals((long)226L, (long)ranges[2].count());
        Assertions.assertEquals((long)226L, (long)ranges[3].count());
        Assertions.assertEquals((long)223L, (long)ranges[4].count());
    }

    private static Map<TopicPartition, Long> makeOffsetMap(int[] partitions, long[] offsets) {
        HashMap<TopicPartition, Long> map = new HashMap<TopicPartition, Long>();
        for (int i = 0; i < partitions.length; ++i) {
            map.put(new TopicPartition(TEST_TOPIC_NAME, partitions[i]), offsets[i]);
        }
        return map;
    }
}

