/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources.debezium;

import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.utilities.sources.debezium.MysqlDebeziumSource;
import org.apache.hudi.utilities.sources.debezium.TestAbstractDebeziumSource;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.junit.jupiter.api.Assertions;

public class TestMysqlDebeziumSource
extends TestAbstractDebeziumSource {
    private static final String MYSQL_GITHUB_SCHEMA = "{\"connect.name\": \"mysql.ghschema.gharchive.Envelope\",\n  \"fields\": [{\"default\": null,\"name\": \"before\",\"type\": [\"null\",{\"connect.name\": \"mysql.ghschema.gharchive.Value\",\n  \"fields\": [{\"name\": \"id\",\"type\": \"string\"},{\"name\": \"date\",\"type\": \"string\"},{\"default\": null,\"name\": \"timestamp\",\n  \"type\": [\"null\",\"long\"]},{\"default\": null,\"name\": \"type\",\"type\": [\"null\",\"string\"]},{\"default\": null,\"name\": \"payload\",\n  \"type\": [\"null\",\"string\"]},{\"default\": null,\"name\": \"org\",\"type\": [\"null\",\"string\"]},{\"default\": null,\"name\": \"created_at\",\n  \"type\": [\"null\",\"long\"]},{\"default\": null,\"name\": \"public\",\"type\": [\"null\",\"boolean\"]}],\"name\": \"Value\",\"type\": \"record\"\n  }]},{\"default\": null,\"name\": \"after\",\"type\": [\"null\",\"Value\"]},{\"name\": \"source\",\"type\": {\"connect.name\": \"io.debezium.connector.mysql.Source\",\n  \"fields\": [{\"name\": \"connector\",\"type\": \"string\"},{\"name\": \"name\",\"type\": \"string\"},{\"name\": \"ts_ms\",\"type\": \"long\"},\n  {\"name\": \"db\",\"type\": \"string\"},{\"name\": \"table\",\"type\": \"string\"},{\"default\": null,\n  \"name\": \"txId\",\"type\": [\"null\",\"long\"]},{\"name\": \"file\",\"type\": \"string\"},{\"default\": null,\"name\": \"pos\",\"type\": [\"null\",\"long\"]},{\"default\": null,\n  \"name\": \"row\",\"type\": [\"null\",\"long\"]}],\"name\": \"Source\",\"namespace\": \"io.debezium.connector.mysql\",\"type\": \"record\"\n  }},{\"name\": \"op\",\"type\": \"string\"},{\"default\": null,\"name\": \"ts_ms\",\"type\": [\"null\",\"long\"]},{\"default\": null,\"name\": \"transaction\",\n  \"type\": [\"null\",{\"fields\": [{\"name\": \"id\",\"type\": \"string\"},{\"name\": \"total_order\",\"type\": \"long\"},{\"name\": \"data_collection_order\",\n  \"type\": \"long\"}],\"name\": \"ConnectDefault\",\"namespace\": \"io.confluent.connect.avro\",\"type\": \"record\"}]}],\"name\": \"Envelope\",\n  \"namespace\": \"mysql.ghschema.gharchive\",\"type\": \"record\"}";
    private static final String TEST_DB = "ghschema";
    private static final String TEST_TABLE = "gharchive";
    private static final long TEST_TS_MS = 12345L;
    private static final String TEST_FILE = "mysql-bin.00007";
    private static final long TEST_POS = 98765L;
    private static final String EXPECTED_TEST_SEQ = "00007.98765";

    @Override
    protected String getIndexName() {
        return "mysql";
    }

    @Override
    protected String getSourceClass() {
        return MysqlDebeziumSource.class.getName();
    }

    @Override
    protected String getSchema() {
        return MYSQL_GITHUB_SCHEMA;
    }

    @Override
    protected GenericRecord generateMetaFields(GenericRecord rec) {
        Schema schema = new Schema.Parser().parse(this.getSchema());
        GenericData.Record sourceRecord = new GenericData.Record(schema.getField("source").schema());
        sourceRecord.put("name", (Object)this.getIndexName());
        sourceRecord.put("connector", (Object)this.getIndexName());
        sourceRecord.put("db", (Object)TEST_DB);
        sourceRecord.put("table", (Object)TEST_TABLE);
        sourceRecord.put("ts_ms", (Object)12345L);
        sourceRecord.put("file", (Object)TEST_FILE);
        sourceRecord.put("pos", (Object)98765L);
        rec.put("source", (Object)sourceRecord);
        return rec;
    }

    @Override
    protected void validateMetaFields(Dataset<Row> records) {
        Assertions.assertTrue((boolean)records.select("db_shard_source_partition", new String[0]).collectAsList().stream().allMatch(r -> r.getString(0).equals(this.getIndexName())));
        Assertions.assertTrue((boolean)records.select("_event_origin_ts_ms", new String[0]).collectAsList().stream().allMatch(r -> r.getLong(0) == 12345L));
        Assertions.assertTrue((boolean)records.select("_event_seq", new String[0]).collectAsList().stream().allMatch(r -> r.getString(0).equals(EXPECTED_TEST_SEQ)));
    }
}

