/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources;

import java.io.IOException;
import java.util.List;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.utilities.deltastreamer.SourceFormatAdapter;
import org.apache.hudi.utilities.sources.InputBatch;
import org.apache.hudi.utilities.sources.S3EventsSource;
import org.apache.hudi.utilities.sources.Source;
import org.apache.hudi.utilities.testutils.UtilitiesTestBase;
import org.apache.hudi.utilities.testutils.sources.AbstractCloudObjectsSourceTestBase;
import org.apache.spark.api.java.JavaRDD;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestS3EventsSource
extends AbstractCloudObjectsSourceTestBase {
    @Override
    @BeforeEach
    public void setup() throws Exception {
        super.setup();
        this.dfsRoot = basePath + "/parquetFiles";
        this.fileSuffix = ".parquet";
        fs.mkdirs(new Path(this.dfsRoot));
    }

    @Override
    @AfterEach
    public void teardown() throws Exception {
        super.teardown();
    }

    @Test
    public void testReadingFromSource() throws IOException {
        SourceFormatAdapter sourceFormatAdapter = new SourceFormatAdapter(this.prepareCloudObjectSource());
        this.generateMessageInQueue(null);
        Assertions.assertEquals((Object)Option.empty(), (Object)sourceFormatAdapter.fetchNewDataInAvroFormat(Option.empty(), Long.MAX_VALUE).getBatch());
        this.generateMessageInQueue("1");
        InputBatch fetch1 = sourceFormatAdapter.fetchNewDataInAvroFormat(Option.empty(), Long.MAX_VALUE);
        Assertions.assertEquals((long)1L, (long)((JavaRDD)fetch1.getBatch().get()).count());
        this.generateMessageInQueue("2");
        InputBatch fetch2 = sourceFormatAdapter.fetchNewDataInAvroFormat(Option.of((Object)fetch1.getCheckpointForNextBatch()), Long.MAX_VALUE);
        Assertions.assertEquals((long)1L, (long)((JavaRDD)fetch2.getBatch().get()).count());
        GenericRecord s3 = (GenericRecord)((GenericRecord)((JavaRDD)fetch2.getBatch().get()).rdd().first()).get("s3");
        GenericRecord s3Object = (GenericRecord)s3.get("object");
        Assertions.assertEquals((Object)"2.parquet", (Object)s3Object.get("key").toString());
    }

    @Override
    public Source prepareCloudObjectSource() {
        TypedProperties props = new TypedProperties();
        props.setProperty("hoodie.deltastreamer.s3.source.queue.url", this.sqsUrl);
        props.setProperty("hoodie.deltastreamer.s3.source.queue.region", this.regionName);
        props.setProperty("hoodie.deltastreamer.s3.source.queue.fs", "hdfs");
        S3EventsSource dfsSource = new S3EventsSource(props, jsc, sparkSession, null);
        dfsSource.sqs = this.sqs;
        return dfsSource;
    }

    @Override
    public void writeNewDataToFile(List<HoodieRecord> records, Path path) throws IOException {
        UtilitiesTestBase.Helpers.saveParquetToDFS(UtilitiesTestBase.Helpers.toGenericRecords(records), path);
    }
}

