/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.utilities.schema.SchemaProvider;
import org.apache.hudi.utilities.sources.InputBatch;
import org.apache.hudi.utilities.testutils.sources.AbstractBaseTestSource;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.SparkSession;

public class TestDataSource
extends AbstractBaseTestSource {
    private static final Logger LOG = LogManager.getLogger(TestDataSource.class);
    public static boolean returnEmptyBatch = false;
    private static int counter = 0;

    public TestDataSource(TypedProperties props, JavaSparkContext sparkContext, SparkSession sparkSession, SchemaProvider schemaProvider) {
        super(props, sparkContext, sparkSession, schemaProvider);
        TestDataSource.initDataGen();
        returnEmptyBatch = false;
    }

    protected InputBatch<JavaRDD<GenericRecord>> fetchNewData(Option<String> lastCheckpointStr, long sourceLimit) {
        int nextCommitNum = (Integer)lastCheckpointStr.map(s -> Integer.parseInt(s) + 1).orElse((Object)0);
        String instantTime = String.format("%05d", nextCommitNum);
        LOG.info((Object)("Source Limit is set to " + sourceLimit));
        if (sourceLimit <= 0L || returnEmptyBatch) {
            LOG.warn((Object)("Return no new data from Test Data source " + counter + ", source limit " + sourceLimit));
            return new InputBatch(Option.empty(), (String)lastCheckpointStr.orElse(null));
        }
        LOG.warn((Object)("Returning valid data from Test Data source " + counter + ", source limit " + sourceLimit));
        ++counter;
        List records = TestDataSource.fetchNextBatch(this.props, (int)sourceLimit, instantTime, 0).collect(Collectors.toList());
        JavaRDD avroRDD = this.sparkContext.parallelize(records, 4);
        return new InputBatch(Option.of((Object)avroRDD), instantTime);
    }
}

