/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.utilities.schema.FilebasedSchemaProvider;
import org.apache.hudi.utilities.schema.SchemaProvider;
import org.apache.hudi.utilities.sources.CsvDFSSource;
import org.apache.hudi.utilities.sources.Source;
import org.apache.hudi.utilities.testutils.UtilitiesTestBase;
import org.apache.hudi.utilities.testutils.sources.AbstractDFSSourceTestBase;
import org.junit.jupiter.api.BeforeEach;

public class TestCsvDFSSource
extends AbstractDFSSourceTestBase {
    @Override
    @BeforeEach
    public void setup() throws Exception {
        super.setup();
        this.dfsRoot = basePath + "/jsonFiles";
        this.fileSuffix = ".json";
        this.useFlattenedSchema = true;
        this.schemaProvider = new FilebasedSchemaProvider(UtilitiesTestBase.Helpers.setupSchemaOnDFS("delta-streamer-config", "source-flattened.avsc"), jsc);
    }

    @Override
    public Source prepareDFSSource() {
        TypedProperties props = new TypedProperties();
        props.setProperty("hoodie.deltastreamer.source.dfs.root", this.dfsRoot);
        props.setProperty("hoodie.deltastreamer.csv.header", Boolean.toString(true));
        props.setProperty("hoodie.deltastreamer.csv.sep", "\t");
        return new CsvDFSSource(props, jsc, sparkSession, (SchemaProvider)this.schemaProvider);
    }

    @Override
    public void writeNewDataToFile(List<HoodieRecord> records, Path path) throws IOException {
        UtilitiesTestBase.Helpers.saveCsvToDFS(true, '\t', UtilitiesTestBase.Helpers.jsonifyRecords(records), fs, path.toString());
    }
}

