/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.functional;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.collection.ImmutablePair;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.utilities.UtilHelpers;
import org.apache.hudi.utilities.schema.HiveSchemaProvider;
import org.apache.hudi.utilities.testutils.SparkClientFunctionalTestHarnessWithHiveSupport;
import org.apache.hudi.utilities.testutils.UtilitiesTestBase;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="functional")
public class TestHiveSchemaProvider
extends SparkClientFunctionalTestHarnessWithHiveSupport {
    private static final Logger LOG = LogManager.getLogger(TestHiveSchemaProvider.class);
    private static final TypedProperties PROPS = new TypedProperties();
    private static final String SOURCE_SCHEMA_TABLE_NAME = "schema_registry.source_schema_tab";
    private static final String TARGET_SCHEMA_TABLE_NAME = "schema_registry.target_schema_tab";

    @BeforeAll
    public static void init() {
        Pair<String, String> dbAndTableName = TestHiveSchemaProvider.paresDBAndTableName(SOURCE_SCHEMA_TABLE_NAME);
        PROPS.setProperty("hoodie.deltastreamer.schemaprovider.source.schema.hive.database", (String)dbAndTableName.getLeft());
        PROPS.setProperty("hoodie.deltastreamer.schemaprovider.source.schema.hive.table", (String)dbAndTableName.getRight());
    }

    @Disabled
    @Test
    public void testSourceSchema() throws Exception {
        try {
            this.createSchemaTable(SOURCE_SCHEMA_TABLE_NAME);
            Schema sourceSchema = UtilHelpers.createSchemaProvider((String)HiveSchemaProvider.class.getName(), (TypedProperties)PROPS, (JavaSparkContext)this.jsc()).getSourceSchema();
            Schema originalSchema = new Schema.Parser().parse(UtilitiesTestBase.Helpers.readFile("delta-streamer-config/hive_schema_provider_source.avsc"));
            for (Schema.Field field : sourceSchema.getFields()) {
                Schema.Field originalField = originalSchema.getField(field.name());
                Assertions.assertTrue((originalField != null ? 1 : 0) != 0);
            }
        }
        catch (HoodieException e) {
            LOG.error((Object)"Failed to get source schema. ", (Throwable)e);
            throw e;
        }
    }

    @Disabled
    @Test
    public void testTargetSchema() throws Exception {
        try {
            Pair<String, String> dbAndTableName = TestHiveSchemaProvider.paresDBAndTableName(TARGET_SCHEMA_TABLE_NAME);
            PROPS.setProperty("hoodie.deltastreamer.schemaprovider.target.schema.hive.database", (String)dbAndTableName.getLeft());
            PROPS.setProperty("hoodie.deltastreamer.schemaprovider.target.schema.hive.table", (String)dbAndTableName.getRight());
            this.createSchemaTable(SOURCE_SCHEMA_TABLE_NAME);
            this.createSchemaTable(TARGET_SCHEMA_TABLE_NAME);
            Schema targetSchema = UtilHelpers.createSchemaProvider((String)HiveSchemaProvider.class.getName(), (TypedProperties)PROPS, (JavaSparkContext)this.jsc()).getTargetSchema();
            Schema originalSchema = new Schema.Parser().parse(UtilitiesTestBase.Helpers.readFile("delta-streamer-config/hive_schema_provider_target.avsc"));
            for (Schema.Field field : targetSchema.getFields()) {
                Schema.Field originalField = originalSchema.getField(field.name());
                Assertions.assertTrue((originalField != null ? 1 : 0) != 0);
            }
        }
        catch (HoodieException e) {
            LOG.error((Object)"Failed to get source/target schema. ", (Throwable)e);
            throw e;
        }
    }

    @Disabled
    @Test
    public void testNotExistTable() {
        String wrongName = "wrong_schema_tab";
        PROPS.setProperty("hoodie.deltastreamer.schemaprovider.source.schema.hive.table", wrongName);
        Assertions.assertThrows(NoSuchTableException.class, () -> {
            try {
                UtilHelpers.createSchemaProvider((String)HiveSchemaProvider.class.getName(), (TypedProperties)PROPS, (JavaSparkContext)this.jsc()).getSourceSchema();
            }
            catch (Throwable exception) {
                while (exception.getCause() != null) {
                    exception = exception.getCause();
                }
                throw exception;
            }
        });
    }

    private static Pair<String, String> paresDBAndTableName(String fullName) {
        String[] dbAndTableName = fullName.split("\\.");
        if (dbAndTableName.length > 1) {
            return new ImmutablePair((Object)dbAndTableName[0], (Object)dbAndTableName[1]);
        }
        return new ImmutablePair((Object)"default", (Object)dbAndTableName[0]);
    }

    private void createSchemaTable(String fullName) throws IOException {
        SparkSession spark = this.spark();
        String createTableSQL = UtilitiesTestBase.Helpers.readFile(String.format("delta-streamer-config/%s.sql", fullName));
        Pair<String, String> dbAndTableName = TestHiveSchemaProvider.paresDBAndTableName(fullName);
        spark.sql(String.format("CREATE DATABASE IF NOT EXISTS %s", dbAndTableName.getLeft()));
        spark.sql(createTableSQL);
    }
}

