/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.functional;

import java.util.Arrays;
import java.util.List;
import org.apache.hudi.testutils.SparkClientFunctionalTestHarness;
import org.apache.hudi.utilities.transform.ChainedTransformer;
import org.apache.hudi.utilities.transform.Transformer;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="functional")
public class TestChainedTransformer
extends SparkClientFunctionalTestHarness {
    @Test
    public void testChainedTransformation() {
        StructType schema = DataTypes.createStructType((StructField[])new StructField[]{DataTypes.createStructField((String)"foo", (DataType)DataTypes.StringType, (boolean)false)});
        Row r1 = RowFactory.create((Object[])new Object[]{"100"});
        Row r2 = RowFactory.create((Object[])new Object[]{"200"});
        Dataset original = this.spark().sqlContext().createDataFrame(Arrays.asList(r1, r2), schema);
        Transformer t1 = (jsc, sparkSession, dataset, properties) -> dataset.withColumnRenamed("foo", "bar");
        Transformer t2 = (jsc, sparkSession, dataset, properties) -> dataset.withColumn("bar", dataset.col("bar").cast(DataTypes.IntegerType));
        ChainedTransformer transformer = new ChainedTransformer(Arrays.asList(t1, t2));
        Dataset transformed = transformer.apply(this.jsc(), this.spark(), original, null);
        Assertions.assertEquals((long)2L, (long)transformed.count());
        Assertions.assertArrayEquals((Object[])new String[]{"bar"}, (Object[])transformed.columns());
        List rows = transformed.collectAsList();
        Assertions.assertEquals((int)100, (int)((Row)rows.get(0)).getInt(0));
        Assertions.assertEquals((int)200, (int)((Row)rows.get(1)).getInt(0));
    }
}

