/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.deser;

import io.confluent.kafka.schemaregistry.client.MockSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.serializers.KafkaAvroSerializer;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.utilities.deser.KafkaAvroSchemaDeserializer;
import org.apache.hudi.utilities.sources.helpers.SchemaTestProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestKafkaAvroSchemaDeserializer {
    private final SchemaRegistryClient schemaRegistry;
    private final KafkaAvroSerializer avroSerializer;
    private final String topic;
    private final Schema origSchema = this.createUserSchema();
    private final Schema evolSchema = this.createExtendUserSchema();
    private Properties config = new Properties();

    public TestKafkaAvroSchemaDeserializer() {
        this.config.put("schema.registry.url", "bogus");
        this.schemaRegistry = new MockSchemaRegistryClient();
        this.avroSerializer = new KafkaAvroSerializer(this.schemaRegistry, new HashMap<Object, Object>(this.config));
        this.topic = "test";
    }

    private Schema createUserSchema() {
        String userSchema = "{\"namespace\": \"example.avro\", \"type\": \"record\", \"name\": \"User\",\"fields\": [{\"name\": \"name\", \"type\": \"string\"}]}";
        Schema.Parser parser = new Schema.Parser();
        return parser.parse(userSchema);
    }

    private IndexedRecord createUserRecord() {
        Schema schema = this.createUserSchema();
        GenericData.Record avroRecord = new GenericData.Record(schema);
        avroRecord.put("name", (Object)"testUser");
        return avroRecord;
    }

    private Schema createExtendUserSchema() {
        String userSchema = "{\"namespace\": \"example.avro\", \"type\": \"record\", \"name\": \"User\",\"fields\": [{\"name\": \"name\", \"type\": \"string\"}, {\"name\": \"age\", \"type\": [\"null\", \"int\"], \"default\": null}]}";
        Schema.Parser parser = new Schema.Parser();
        return parser.parse(userSchema);
    }

    private IndexedRecord createExtendUserRecord() {
        Schema schema = this.createExtendUserSchema();
        GenericData.Record avroRecord = new GenericData.Record(schema);
        avroRecord.put("name", (Object)"testUser");
        avroRecord.put("age", (Object)30);
        return avroRecord;
    }

    @Test
    public void testKafkaAvroSchemaDeserializer() {
        IndexedRecord avroRecord = this.createUserRecord();
        this.config.put("hoodie.deltastreamer.source.kafka.value.deserializer.schema", this.origSchema.toString());
        KafkaAvroSchemaDeserializer avroDeserializer = new KafkaAvroSchemaDeserializer(this.schemaRegistry, new HashMap<Object, Object>(this.config));
        avroDeserializer.configure(new HashMap<Object, Object>(this.config), false);
        byte[] bytesOrigRecord = this.avroSerializer.serialize(this.topic, (Object)avroRecord);
        Assertions.assertEquals((Object)avroRecord, (Object)avroDeserializer.deserialize(false, this.topic, Boolean.valueOf(false), bytesOrigRecord, this.origSchema));
        IndexedRecord avroRecordWithAllField = this.createExtendUserRecord();
        byte[] bytesExtendedRecord = this.avroSerializer.serialize(this.topic, (Object)avroRecordWithAllField);
        SchemaTestProvider.schemaToReturn.set(this.evolSchema);
        this.config.put("hoodie.deltastreamer.source.kafka.value.deserializer.schema", this.evolSchema.toString());
        avroDeserializer = new KafkaAvroSchemaDeserializer(this.schemaRegistry, new HashMap<Object, Object>(this.config));
        avroDeserializer.configure(new HashMap<Object, Object>(this.config), false);
        IndexedRecord avroRecordWithAllFieldActual = (IndexedRecord)avroDeserializer.deserialize(false, this.topic, Boolean.valueOf(false), bytesExtendedRecord, this.evolSchema);
        Assertions.assertEquals((Object)avroRecordWithAllField, (Object)avroRecordWithAllFieldActual);
        Assertions.assertEquals((Object)avroRecordWithAllFieldActual.getSchema(), (Object)this.evolSchema);
        IndexedRecord actualRec = (IndexedRecord)avroDeserializer.deserialize(false, this.topic, Boolean.valueOf(false), bytesOrigRecord, this.origSchema);
        Assertions.assertNotEquals((Object)avroRecord, (Object)actualRec);
        GenericRecord genericRecord = (GenericRecord)actualRec;
        GenericRecord origGenRec = (GenericRecord)avroRecord;
        Assertions.assertEquals((Object)genericRecord.get("name").toString(), (Object)origGenRec.get("name").toString());
        Assertions.assertEquals((Object)actualRec.getSchema(), (Object)this.evolSchema);
        Assertions.assertNull((Object)genericRecord.get("age"));
    }

    protected TypedProperties getConvertToTypedProperties(Map<String, ?> configs) {
        TypedProperties typedProperties = new TypedProperties();
        for (Map.Entry<String, ?> entry : configs.entrySet()) {
            typedProperties.put((Object)entry.getKey(), entry.getValue());
        }
        return typedProperties;
    }
}

