/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.deltastreamer.multisync;

import java.util.Arrays;
import java.util.Collections;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.utilities.deltastreamer.HoodieDeltaStreamer;
import org.apache.hudi.utilities.deltastreamer.HoodieDeltaStreamerTestBase;
import org.apache.hudi.utilities.deltastreamer.multisync.MockSyncTool1;
import org.apache.hudi.utilities.deltastreamer.multisync.MockSyncTool2;
import org.apache.hudi.utilities.deltastreamer.multisync.MockSyncToolException1;
import org.apache.hudi.utilities.deltastreamer.multisync.MockSyncToolException2;
import org.apache.hudi.utilities.schema.FilebasedSchemaProvider;
import org.apache.hudi.utilities.sources.TestDataSource;
import org.apache.hudi.utilities.testutils.UtilitiesTestBase;
import org.apache.hudi.utilities.transform.SqlQueryBasedTransformer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestMultipleMetaSync
extends HoodieDeltaStreamerTestBase {
    @Test
    void testMultipleMetaStore() throws Exception {
        String tableBasePath = basePath + "/test_multiple_metastore";
        MockSyncTool1.syncSuccess = false;
        MockSyncTool2.syncSuccess = false;
        HoodieDeltaStreamer.Config cfg = this.getConfig(tableBasePath, TestMultipleMetaSync.getSyncNames("MockSyncTool1", "MockSyncTool2"));
        new HoodieDeltaStreamer(cfg, jsc, fs, (Configuration)hiveServer.getHiveConf()).sync();
        Assertions.assertTrue((boolean)MockSyncTool1.syncSuccess);
        Assertions.assertTrue((boolean)MockSyncTool2.syncSuccess);
    }

    @ParameterizedTest
    @MethodSource(value={"withOneException"})
    void testeWithException(String syncClassNames) {
        String tableBasePath = basePath + "/test_multiple_metastore_exception";
        MockSyncTool1.syncSuccess = false;
        MockSyncTool2.syncSuccess = false;
        HoodieDeltaStreamer.Config cfg = this.getConfig(tableBasePath, syncClassNames);
        Exception e = (Exception)Assertions.assertThrows(HoodieException.class, () -> new HoodieDeltaStreamer(cfg, jsc, fs, (Configuration)hiveServer.getHiveConf()).sync());
        Assertions.assertTrue((boolean)e.getMessage().contains(MockSyncToolException1.class.getName()));
        Assertions.assertTrue((boolean)MockSyncTool1.syncSuccess);
        Assertions.assertTrue((boolean)MockSyncTool2.syncSuccess);
    }

    @Test
    void testMultipleExceptions() {
        String tableBasePath = basePath + "/test_multiple_metastore_multiple_exception";
        MockSyncTool1.syncSuccess = false;
        MockSyncTool2.syncSuccess = false;
        HoodieDeltaStreamer.Config cfg = this.getConfig(tableBasePath, TestMultipleMetaSync.getSyncNames("MockSyncTool1", "MockSyncTool2", "MockSyncToolException1", "MockSyncToolException2"));
        Exception e = (Exception)Assertions.assertThrows(HoodieException.class, () -> new HoodieDeltaStreamer(cfg, jsc, fs, (Configuration)hiveServer.getHiveConf()).sync());
        Assertions.assertTrue((boolean)e.getMessage().contains(MockSyncToolException1.class.getName()));
        Assertions.assertTrue((boolean)e.getMessage().contains(MockSyncToolException2.class.getName()));
        Assertions.assertTrue((boolean)MockSyncTool1.syncSuccess);
        Assertions.assertTrue((boolean)MockSyncTool2.syncSuccess);
    }

    HoodieDeltaStreamer.Config getConfig(String basePath, String syncClassNames) {
        HoodieDeltaStreamer.Config cfg = new HoodieDeltaStreamer.Config();
        cfg.targetBasePath = basePath;
        cfg.targetTableName = "hoodie_trips";
        cfg.tableType = "COPY_ON_WRITE";
        cfg.sourceClassName = TestDataSource.class.getName();
        cfg.transformerClassNames = Collections.singletonList(SqlQueryBasedTransformer.class.getName());
        cfg.schemaProviderClassName = FilebasedSchemaProvider.class.getName();
        cfg.syncClientToolClassNames = syncClassNames;
        cfg.operation = WriteOperationType.BULK_INSERT;
        cfg.enableHiveSync = true;
        cfg.sourceOrderingField = "timestamp";
        cfg.propsFilePath = UtilitiesTestBase.basePath + "/test-source.properties";
        cfg.configs.add("hoodie.datasource.hive_sync.partition_fields=year,month,day");
        cfg.sourceLimit = 1000L;
        return cfg;
    }

    private static String getSyncNames(String ... syncs) {
        return Arrays.stream(syncs).map(s -> "org.apache.hudi.utilities.deltastreamer.multisync." + s).collect(Collectors.joining(","));
    }

    private static Stream<Arguments> withOneException() {
        return Stream.of(Arguments.of((Object[])new Object[]{TestMultipleMetaSync.getSyncNames("MockSyncTool1", "MockSyncTool2", "MockSyncToolException1")}), Arguments.of((Object[])new Object[]{TestMultipleMetaSync.getSyncNames("MockSyncTool1", "MockSyncToolException1", "MockSyncTool2")}), Arguments.of((Object[])new Object[]{TestMultipleMetaSync.getSyncNames("MockSyncToolException1", "MockSyncTool1", "MockSyncTool2")}));
    }
}

