/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.hudi.avro.model.HoodieIndexCommitMetadata;
import org.apache.hudi.avro.model.HoodieIndexPartitionInfo;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.testutils.Assertions;
import org.apache.hudi.testutils.SparkClientFunctionalTestHarness;
import org.apache.hudi.testutils.providers.SparkProvider;
import org.apache.hudi.utilities.HoodieIndexer;
import org.apache.spark.api.java.JavaRDD;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestHoodieIndexer
extends SparkClientFunctionalTestHarness
implements SparkProvider {
    private static final HoodieTestDataGenerator DATA_GENERATOR = new HoodieTestDataGenerator(0L);
    private static int colStatsFileGroupCount = (Integer)HoodieMetadataConfig.METADATA_INDEX_COLUMN_STATS_FILE_GROUP_COUNT.defaultValue();
    private HoodieTableMetaClient metaClient;

    @BeforeEach
    public void init() throws IOException {
        this.metaClient = this.getHoodieMetaClient(HoodieTableType.COPY_ON_WRITE);
    }

    @AfterAll
    public static void cleanup() {
        DATA_GENERATOR.close();
    }

    @Test
    public void testGetRequestedPartitionTypes() {
        HoodieIndexer.Config config = new HoodieIndexer.Config();
        config.basePath = this.basePath();
        config.tableName = "indexer_test";
        config.indexTypes = "FILES,BLOOM_FILTERS,COLUMN_STATS";
        HoodieIndexer indexer = new HoodieIndexer(this.jsc(), config);
        List partitionTypes = indexer.getRequestedPartitionTypes(config.indexTypes, Option.empty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)partitionTypes.contains(MetadataPartitionType.FILES));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)partitionTypes.contains(MetadataPartitionType.BLOOM_FILTERS));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)partitionTypes.contains(MetadataPartitionType.COLUMN_STATS));
    }

    @Test
    public void testIsIndexBuiltForAllRequestedTypes() {
        HoodieIndexer.Config config = new HoodieIndexer.Config();
        config.basePath = this.basePath();
        config.tableName = "indexer_test";
        config.indexTypes = "BLOOM_FILTERS,COLUMN_STATS";
        HoodieIndexer indexer = new HoodieIndexer(this.jsc(), config);
        HoodieIndexCommitMetadata commitMetadata = HoodieIndexCommitMetadata.newBuilder().setIndexPartitionInfos(Arrays.asList(new HoodieIndexPartitionInfo(Integer.valueOf(1), MetadataPartitionType.COLUMN_STATS.getPartitionPath(), "0000"))).build();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)indexer.isIndexBuiltForAllRequestedTypes(commitMetadata.getIndexPartitionInfos()));
        config.indexTypes = "COLUMN_STATS";
        indexer = new HoodieIndexer(this.jsc(), config);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)indexer.isIndexBuiltForAllRequestedTypes(commitMetadata.getIndexPartitionInfos()));
    }

    @Test
    public void testIndexerWithNotAllIndexesEnabled() {
        String tableName = "indexer_test";
        HoodieMetadataConfig.Builder metadataConfigBuilder = TestHoodieIndexer.getMetadataConfigBuilder(true, false).withMetadataIndexBloomFilter(true);
        this.initializeWriteClient(metadataConfigBuilder.build(), tableName);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient).getTableConfig().getMetadataPartitions().contains(MetadataPartitionType.FILES.getPartitionPath()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient).getTableConfig().getMetadataPartitions().contains(MetadataPartitionType.BLOOM_FILTERS.getPartitionPath()));
        this.indexMetadataPartitionsAndAssert(MetadataPartitionType.COLUMN_STATS, Arrays.asList(MetadataPartitionType.FILES, MetadataPartitionType.BLOOM_FILTERS), Collections.emptyList(), tableName);
    }

    @Test
    public void testIndexerWithFilesPartition() {
        String tableName = "indexer_test";
        HoodieMetadataConfig.Builder metadataConfigBuilder = TestHoodieIndexer.getMetadataConfigBuilder(false, false).withMetadataIndexBloomFilter(true);
        this.initializeWriteClient(metadataConfigBuilder.build(), tableName);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient).getTableConfig().getMetadataPartitions().contains(MetadataPartitionType.FILES.getPartitionPath()));
        this.indexMetadataPartitionsAndAssert(MetadataPartitionType.FILES, Collections.emptyList(), Arrays.asList(MetadataPartitionType.COLUMN_STATS, MetadataPartitionType.BLOOM_FILTERS), tableName);
    }

    private static Stream<Arguments> colStatsFileGroupCountParams() {
        return Stream.of(Arguments.of((Object[])new Object[]{1}), Arguments.of((Object[])new Object[]{2}), Arguments.of((Object[])new Object[]{4}), Arguments.of((Object[])new Object[]{8}));
    }

    @ParameterizedTest
    @MethodSource(value={"colStatsFileGroupCountParams"})
    public void testColStatsFileGroupCount(int colStatsFileGroupCount) {
        TestHoodieIndexer.colStatsFileGroupCount = colStatsFileGroupCount;
        String tableName = "indexer_test";
        HoodieMetadataConfig.Builder metadataConfigBuilder = TestHoodieIndexer.getMetadataConfigBuilder(false, false).withMetadataIndexBloomFilter(true);
        this.initializeWriteClient(metadataConfigBuilder.build(), tableName);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient).getTableConfig().getMetadataPartitions().contains(MetadataPartitionType.FILES.getPartitionPath()));
        this.indexMetadataPartitionsAndAssert(MetadataPartitionType.FILES, Collections.emptyList(), Arrays.asList(MetadataPartitionType.COLUMN_STATS, MetadataPartitionType.BLOOM_FILTERS), tableName);
        this.indexMetadataPartitionsAndAssert(MetadataPartitionType.COLUMN_STATS, Collections.singletonList(MetadataPartitionType.FILES), Arrays.asList(MetadataPartitionType.BLOOM_FILTERS), tableName);
        HoodieTableMetaClient metadataMetaClient = HoodieTableMetaClient.builder().setConf(this.metaClient.getHadoopConf()).setBasePath(this.metaClient.getMetaPath() + "/metadata").build();
        List partitionFileSlices = HoodieTableMetadataUtil.getPartitionLatestMergedFileSlices((HoodieTableMetaClient)metadataMetaClient, (HoodieTableFileSystemView)HoodieTableMetadataUtil.getFileSystemView((HoodieTableMetaClient)metadataMetaClient), (String)MetadataPartitionType.COLUMN_STATS.getPartitionPath());
        org.junit.jupiter.api.Assertions.assertEquals((int)partitionFileSlices.size(), (int)colStatsFileGroupCount);
    }

    @Test
    public void testIndexerForExceptionWithNonFilesPartition() {
        String tableName = "indexer_test";
        HoodieMetadataConfig.Builder metadataConfigBuilder = TestHoodieIndexer.getMetadataConfigBuilder(false, false);
        this.initializeWriteClient(metadataConfigBuilder.build(), tableName);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient).getTableConfig().getMetadataPartitions().contains(MetadataPartitionType.FILES.getPartitionPath()));
        HoodieIndexer.Config config = new HoodieIndexer.Config();
        String propsPath = Objects.requireNonNull(((Object)((Object)this)).getClass().getClassLoader().getResource("delta-streamer-config/indexer.properties")).getPath();
        config.basePath = this.basePath();
        config.tableName = tableName;
        config.indexTypes = MetadataPartitionType.COLUMN_STATS.name();
        config.runningMode = "scheduleandexecute";
        config.propsFilePath = propsPath;
        HoodieIndexer indexer = new HoodieIndexer(this.jsc(), config);
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)indexer.start(0));
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.metaClient.getTableConfig().getMetadataPartitions().contains(MetadataPartitionType.FILES.getPartitionPath()));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.metaClient.getTableConfig().getMetadataPartitions().contains(MetadataPartitionType.COLUMN_STATS.getPartitionPath()));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.metaClient.getTableConfig().getMetadataPartitions().contains(MetadataPartitionType.BLOOM_FILTERS.getPartitionPath()));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)HoodieTableMetadataUtil.metadataPartitionExists((String)this.basePath(), (HoodieEngineContext)this.context(), (MetadataPartitionType)MetadataPartitionType.FILES));
        this.indexMetadataPartitionsAndAssert(MetadataPartitionType.FILES, Collections.emptyList(), Arrays.asList(MetadataPartitionType.COLUMN_STATS, MetadataPartitionType.BLOOM_FILTERS), tableName);
        this.indexMetadataPartitionsAndAssert(MetadataPartitionType.COLUMN_STATS, Collections.singletonList(MetadataPartitionType.FILES), Arrays.asList(MetadataPartitionType.BLOOM_FILTERS), tableName);
        HoodieTableMetaClient metadataMetaClient = HoodieTableMetaClient.builder().setConf(this.metaClient.getHadoopConf()).setBasePath(this.metaClient.getMetaPath() + "/metadata").build();
        List partitionFileSlices = HoodieTableMetadataUtil.getPartitionLatestMergedFileSlices((HoodieTableMetaClient)metadataMetaClient, (HoodieTableFileSystemView)HoodieTableMetadataUtil.getFileSystemView((HoodieTableMetaClient)metadataMetaClient), (String)MetadataPartitionType.COLUMN_STATS.getPartitionPath());
        org.junit.jupiter.api.Assertions.assertEquals((int)partitionFileSlices.size(), (Integer)((Integer)HoodieMetadataConfig.METADATA_INDEX_COLUMN_STATS_FILE_GROUP_COUNT.defaultValue()));
    }

    private void initializeWriteClient(HoodieMetadataConfig metadataConfig, String tableName) {
        HoodieWriteConfig.Builder writeConfigBuilder = TestHoodieIndexer.getWriteConfigBuilder(this.basePath(), tableName);
        HoodieWriteConfig writeConfig = writeConfigBuilder.withMetadataConfig(metadataConfig).build();
        SparkRDDWriteClient writeClient = new SparkRDDWriteClient((HoodieEngineContext)this.context(), writeConfig);
        String instant = "0001";
        writeClient.startCommitWithTime(instant);
        List records = DATA_GENERATOR.generateInserts(instant, Integer.valueOf(100));
        JavaRDD result = writeClient.upsert(this.jsc().parallelize(records, 1), instant);
        List statuses = result.collect();
        Assertions.assertNoWriteErrors((List)statuses);
    }

    private void indexMetadataPartitionsAndAssert(MetadataPartitionType partitionTypeToIndex, List<MetadataPartitionType> alreadyCompletedPartitions, List<MetadataPartitionType> nonExistantPartitions, String tableName) {
        HoodieIndexer.Config config = new HoodieIndexer.Config();
        String propsPath = Objects.requireNonNull(((Object)((Object)this)).getClass().getClassLoader().getResource("delta-streamer-config/indexer.properties")).getPath();
        config.basePath = this.basePath();
        config.tableName = tableName;
        config.indexTypes = partitionTypeToIndex.name();
        config.runningMode = "scheduleandexecute";
        config.propsFilePath = propsPath;
        if (partitionTypeToIndex.getPartitionPath().equals(MetadataPartitionType.COLUMN_STATS.getPartitionPath())) {
            config.configs.add(HoodieMetadataConfig.METADATA_INDEX_COLUMN_STATS_FILE_GROUP_COUNT.key() + "=" + colStatsFileGroupCount);
        }
        HoodieIndexer indexer = new HoodieIndexer(this.jsc(), config);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)indexer.start(0));
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        Set completedPartitions = this.metaClient.getTableConfig().getMetadataPartitions();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)completedPartitions.contains(partitionTypeToIndex.getPartitionPath()));
        alreadyCompletedPartitions.forEach(entry -> org.junit.jupiter.api.Assertions.assertTrue((boolean)completedPartitions.contains(entry.getPartitionPath())));
        nonExistantPartitions.forEach(entry -> org.junit.jupiter.api.Assertions.assertFalse((boolean)completedPartitions.contains(entry.getPartitionPath())));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)HoodieTableMetadataUtil.metadataPartitionExists((String)this.basePath(), (HoodieEngineContext)this.context(), (MetadataPartitionType)partitionTypeToIndex));
        alreadyCompletedPartitions.forEach(entry -> org.junit.jupiter.api.Assertions.assertTrue((boolean)HoodieTableMetadataUtil.metadataPartitionExists((String)this.basePath(), (HoodieEngineContext)this.context(), (MetadataPartitionType)entry)));
    }

    @Test
    public void testIndexerDropPartitionDeletesInstantFromTimeline() {
        String tableName = "indexer_test";
        HoodieWriteConfig.Builder writeConfigBuilder = TestHoodieIndexer.getWriteConfigBuilder(this.basePath(), tableName);
        HoodieMetadataConfig.Builder metadataConfigBuilder = TestHoodieIndexer.getMetadataConfigBuilder(true, false).withMetadataIndexBloomFilter(true);
        HoodieWriteConfig writeConfig = writeConfigBuilder.withMetadataConfig(metadataConfigBuilder.build()).build();
        SparkRDDWriteClient writeClient = new SparkRDDWriteClient((HoodieEngineContext)this.context(), writeConfig);
        String instant = "0001";
        writeClient.startCommitWithTime(instant);
        List records = DATA_GENERATOR.generateInserts(instant, Integer.valueOf(100));
        JavaRDD result = writeClient.upsert(this.jsc().parallelize(records, 1), instant);
        List statuses = result.collect();
        Assertions.assertNoWriteErrors((List)statuses);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient).getTableConfig().getMetadataPartitions().contains(MetadataPartitionType.FILES.getPartitionPath()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)HoodieTableMetadataUtil.metadataPartitionExists((String)this.basePath(), (HoodieEngineContext)this.context(), (MetadataPartitionType)MetadataPartitionType.FILES));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient).getTableConfig().getMetadataPartitions().contains(MetadataPartitionType.BLOOM_FILTERS.getPartitionPath()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)HoodieTableMetadataUtil.metadataPartitionExists((String)this.basePath(), (HoodieEngineContext)this.context(), (MetadataPartitionType)MetadataPartitionType.BLOOM_FILTERS));
        HoodieIndexer.Config config = new HoodieIndexer.Config();
        String propsPath = Objects.requireNonNull(((Object)((Object)this)).getClass().getClassLoader().getResource("delta-streamer-config/indexer.properties")).getPath();
        config.basePath = this.basePath();
        config.tableName = tableName;
        config.indexTypes = MetadataPartitionType.COLUMN_STATS.name();
        config.runningMode = "schedule";
        config.propsFilePath = propsPath;
        HoodieIndexer indexer = new HoodieIndexer(this.jsc(), config);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)indexer.start(0));
        Option indexInstantInTimeline = this.metaClient.reloadActiveTimeline().filterPendingIndexTimeline().lastInstant();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)indexInstantInTimeline.isPresent());
        org.junit.jupiter.api.Assertions.assertEquals((Object)HoodieInstant.State.REQUESTED, (Object)((HoodieInstant)indexInstantInTimeline.get()).getState());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)HoodieTableMetadataUtil.metadataPartitionExists((String)this.basePath(), (HoodieEngineContext)this.context(), (MetadataPartitionType)MetadataPartitionType.COLUMN_STATS));
        config.runningMode = "dropindex";
        indexer = new HoodieIndexer(this.jsc(), config);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)indexer.start(0));
        indexInstantInTimeline = this.metaClient.reloadActiveTimeline().filterPendingIndexTimeline().lastInstant();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)indexInstantInTimeline.isPresent());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)HoodieTableMetadataUtil.metadataPartitionExists((String)this.basePath(), (HoodieEngineContext)this.context(), (MetadataPartitionType)MetadataPartitionType.COLUMN_STATS));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient).getTableConfig().getMetadataPartitions().contains(MetadataPartitionType.FILES.getPartitionPath()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)HoodieTableMetadataUtil.metadataPartitionExists((String)this.basePath(), (HoodieEngineContext)this.context(), (MetadataPartitionType)MetadataPartitionType.FILES));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient).getTableConfig().getMetadataPartitions().contains(MetadataPartitionType.BLOOM_FILTERS.getPartitionPath()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)HoodieTableMetadataUtil.metadataPartitionExists((String)this.basePath(), (HoodieEngineContext)this.context(), (MetadataPartitionType)MetadataPartitionType.BLOOM_FILTERS));
    }

    @Test
    public void testTwoIndexersOneCreateOneDropPartition() {
        String tableName = "indexer_test";
        HoodieWriteConfig.Builder writeConfigBuilder = TestHoodieIndexer.getWriteConfigBuilder(this.basePath(), tableName);
        HoodieMetadataConfig.Builder metadataConfigBuilder = TestHoodieIndexer.getMetadataConfigBuilder(true, false);
        HoodieWriteConfig writeConfig = writeConfigBuilder.withMetadataConfig(metadataConfigBuilder.build()).build();
        SparkRDDWriteClient writeClient = new SparkRDDWriteClient((HoodieEngineContext)this.context(), writeConfig);
        String instant = "0001";
        writeClient.startCommitWithTime(instant);
        List records = DATA_GENERATOR.generateInserts(instant, Integer.valueOf(100));
        JavaRDD result = writeClient.upsert(this.jsc().parallelize(records, 1), instant);
        List statuses = result.collect();
        Assertions.assertNoWriteErrors((List)statuses);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient).getTableConfig().getMetadataPartitions().contains(MetadataPartitionType.FILES.getPartitionPath()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)HoodieTableMetadataUtil.metadataPartitionExists((String)this.basePath(), (HoodieEngineContext)this.context(), (MetadataPartitionType)MetadataPartitionType.FILES));
        HoodieIndexer.Config config = this.getHoodieIndexConfig(MetadataPartitionType.BLOOM_FILTERS.name(), "scheduleandexecute", "delta-streamer-config/indexer-only-bloom.properties", tableName);
        HoodieIndexer indexer = new HoodieIndexer(this.jsc(), config);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)indexer.start(0));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient).getTableConfig().getMetadataPartitions().contains(MetadataPartitionType.BLOOM_FILTERS.getPartitionPath()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)HoodieTableMetadataUtil.metadataPartitionExists((String)this.basePath(), (HoodieEngineContext)this.context(), (MetadataPartitionType)MetadataPartitionType.BLOOM_FILTERS));
        Option bloomIndexInstant = this.metaClient.reloadActiveTimeline().filterCompletedIndexTimeline().lastInstant();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)bloomIndexInstant.isPresent());
        config = this.getHoodieIndexConfig(MetadataPartitionType.COLUMN_STATS.name(), "schedule", "delta-streamer-config/indexer.properties", tableName);
        indexer = new HoodieIndexer(this.jsc(), config);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)indexer.start(0));
        Option columnStatsIndexInstant = this.metaClient.reloadActiveTimeline().filterPendingIndexTimeline().lastInstant();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)columnStatsIndexInstant.isPresent());
        org.junit.jupiter.api.Assertions.assertEquals((Object)HoodieInstant.State.REQUESTED, (Object)((HoodieInstant)columnStatsIndexInstant.get()).getState());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)HoodieTableMetadataUtil.metadataPartitionExists((String)this.basePath(), (HoodieEngineContext)this.context(), (MetadataPartitionType)MetadataPartitionType.COLUMN_STATS));
        this.dropIndexAndAssert(MetadataPartitionType.COLUMN_STATS, "delta-streamer-config/indexer.properties", (Option<HoodieInstant>)Option.empty(), tableName);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient).getTableConfig().getMetadataPartitions().contains(MetadataPartitionType.FILES.getPartitionPath()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)HoodieTableMetadataUtil.metadataPartitionExists((String)this.basePath(), (HoodieEngineContext)this.context(), (MetadataPartitionType)MetadataPartitionType.FILES));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient).getTableConfig().getMetadataPartitions().contains(MetadataPartitionType.BLOOM_FILTERS.getPartitionPath()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)HoodieTableMetadataUtil.metadataPartitionExists((String)this.basePath(), (HoodieEngineContext)this.context(), (MetadataPartitionType)MetadataPartitionType.BLOOM_FILTERS));
        this.dropIndexAndAssert(MetadataPartitionType.BLOOM_FILTERS, "delta-streamer-config/indexer-only-bloom.properties", (Option<HoodieInstant>)bloomIndexInstant, tableName);
    }

    private void dropIndexAndAssert(MetadataPartitionType indexType, String resourceFilePath, Option<HoodieInstant> completedIndexInstant, String tableName) {
        HoodieIndexer.Config config = this.getHoodieIndexConfig(indexType.name(), "dropindex", resourceFilePath, tableName);
        HoodieIndexer indexer = new HoodieIndexer(this.jsc(), config);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)indexer.start(0));
        Option pendingFlights = this.metaClient.reloadActiveTimeline().filterPendingIndexTimeline().lastInstant();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)pendingFlights.isPresent());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)HoodieTableMetadataUtil.metadataPartitionExists((String)this.basePath(), (HoodieEngineContext)this.context(), (MetadataPartitionType)indexType));
        if (completedIndexInstant.isPresent()) {
            org.junit.jupiter.api.Assertions.assertEquals(completedIndexInstant, (Object)this.metaClient.reloadActiveTimeline().filterCompletedIndexTimeline().lastInstant());
        }
    }

    private HoodieIndexer.Config getHoodieIndexConfig(String indexType, String runMode, String resourceFilePath, String tableName) {
        HoodieIndexer.Config config = new HoodieIndexer.Config();
        String propsPath = Objects.requireNonNull(((Object)((Object)this)).getClass().getClassLoader().getResource(resourceFilePath)).getPath();
        config.basePath = this.basePath();
        config.tableName = tableName;
        config.indexTypes = indexType;
        config.runningMode = runMode;
        config.propsFilePath = propsPath;
        return config;
    }

    private static HoodieWriteConfig.Builder getWriteConfigBuilder(String basePath, String tableName) {
        return HoodieWriteConfig.newBuilder().withPath(basePath).withSchema("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}").withParallelism(2, 2).withBulkInsertParallelism(2).withFinalizeWriteParallelism(2).withDeleteParallelism(2).withTimelineLayoutVersion(TimelineLayoutVersion.CURR_VERSION.intValue()).forTable(tableName);
    }

    private static HoodieMetadataConfig.Builder getMetadataConfigBuilder(boolean enable, boolean asyncIndex) {
        return HoodieMetadataConfig.newBuilder().enable(enable).withAsyncIndex(asyncIndex);
    }
}

