/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.yarn.cli;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.flink.client.cli.AbstractCustomCommandLine;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.yarn.configuration.YarnConfigOptions;
import org.apache.flink.yarn.executors.YarnSessionClusterExecutor;

abstract class AbstractYarnCli
extends AbstractCustomCommandLine {
    public static final String ID = "yarn-cluster";
    protected final Option applicationId;
    protected final Option addressOption = new Option("m", "jobmanager", true, "Set to yarn-cluster to use YARN execution mode.");
    protected final Configuration configuration;

    protected AbstractYarnCli(Configuration configuration, String shortPrefix, String longPrefix) {
        this.configuration = configuration;
        this.applicationId = new Option(shortPrefix + "id", longPrefix + "applicationId", true, "Attach to running YARN session");
    }

    public boolean isActive(CommandLine commandLine) {
        String jobManagerOption = commandLine.getOptionValue(this.addressOption.getOpt(), null);
        boolean yarnJobManager = ID.equals(jobManagerOption);
        boolean hasYarnAppId = commandLine.hasOption(this.applicationId.getOpt()) || this.configuration.getOptional(YarnConfigOptions.APPLICATION_ID).isPresent();
        boolean hasYarnExecutor = YarnSessionClusterExecutor.NAME.equalsIgnoreCase((String)this.configuration.get(DeploymentOptions.TARGET));
        return hasYarnExecutor || yarnJobManager || hasYarnAppId;
    }

    public void addGeneralOptions(Options baseOptions) {
        super.addGeneralOptions(baseOptions);
        baseOptions.addOption(this.applicationId);
        baseOptions.addOption(this.addressOption);
    }

    public String getId() {
        return ID;
    }
}

