/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.yarn;

import java.util.Objects;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonFactory;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonFactoryBuilder;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.jackson.JacksonMapperFactory;
import org.apache.flink.yarn.Utils;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class YarnLocalResourceDescriptor {
    private static final Logger LOG = LoggerFactory.getLogger(YarnLocalResourceDescriptor.class);
    private static final ObjectMapper OBJECT_MAPPER = JacksonMapperFactory.createObjectMapper((JsonFactory)new JsonFactoryBuilder().quoteChar('\'').build()).enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_SINGLE_QUOTES});
    private final String resourceKey;
    private final Path path;
    private final long size;
    private final long modificationTime;
    private final LocalResourceVisibility visibility;
    private final LocalResourceType resourceType;

    YarnLocalResourceDescriptor(String resourceKey, Path path, long resourceSize, long modificationTime, LocalResourceVisibility visibility, LocalResourceType resourceType) {
        this.resourceKey = (String)Preconditions.checkNotNull((Object)resourceKey);
        this.path = (Path)Preconditions.checkNotNull((Object)path);
        this.size = resourceSize;
        this.modificationTime = modificationTime;
        this.visibility = (LocalResourceVisibility)Preconditions.checkNotNull((Object)visibility);
        this.resourceType = (LocalResourceType)Preconditions.checkNotNull((Object)resourceType);
    }

    boolean alreadyRegisteredAsLocalResource() {
        return this.visibility.equals((Object)LocalResourceVisibility.PUBLIC);
    }

    String getResourceKey() {
        return this.resourceKey;
    }

    Path getPath() {
        return this.path;
    }

    long getSize() {
        return this.size;
    }

    long getModificationTime() {
        return this.modificationTime;
    }

    LocalResourceVisibility getVisibility() {
        return this.visibility;
    }

    LocalResourceType getResourceType() {
        return this.resourceType;
    }

    static YarnLocalResourceDescriptor fromString(String desc) throws Exception {
        try {
            JsonNode node = OBJECT_MAPPER.readTree(desc);
            if (!YarnLocalResourceDescriptor.validate(node)) {
                throw new FlinkException("Error to parse YarnLocalResourceDescriptor from " + desc);
            }
            return new YarnLocalResourceDescriptor(node.get("resourceKey").asText(), new Path(node.get("path").asText()), node.get("size").asLong(), node.get("modificationTime").asLong(), LocalResourceVisibility.valueOf((String)node.get("visibility").asText()), LocalResourceType.valueOf((String)node.get("resourceType").asText()));
        }
        catch (JsonProcessingException e) {
            throw new FlinkException("Error to parse YarnLocalResourceDescriptor from " + desc, (Throwable)e);
        }
    }

    private static boolean validate(JsonNode node) {
        return !node.isNull() && node.hasNonNull("resourceKey") && node.hasNonNull("path") && node.hasNonNull("size") && node.hasNonNull("modificationTime") && node.hasNonNull("visibility") && node.hasNonNull("resourceType");
    }

    static YarnLocalResourceDescriptor fromFileStatus(String key, FileStatus fileStatus, LocalResourceVisibility visibility, LocalResourceType resourceType) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)fileStatus);
        Preconditions.checkNotNull((Object)visibility);
        return new YarnLocalResourceDescriptor(key, fileStatus.getPath(), fileStatus.getLen(), fileStatus.getModificationTime(), visibility, resourceType);
    }

    public String toString() {
        try {
            ObjectNode node = OBJECT_MAPPER.createObjectNode();
            node.put("resourceKey", this.resourceKey);
            node.put("path", this.path.toString());
            node.put("size", this.size);
            node.put("modificationTime", this.modificationTime);
            node.put("visibility", this.visibility.toString());
            node.put("resourceType", this.resourceType.toString());
            return OBJECT_MAPPER.writeValueAsString((Object)node);
        }
        catch (JsonProcessingException e) {
            LOG.error("Could not serialize YarnLocalResourceDescriptor to String.", (Throwable)e);
            throw new RuntimeException("Could not serialize YarnLocalResourceDescriptor[%s] to String.", e);
        }
    }

    public int hashCode() {
        int result = Objects.hashCode(this.resourceKey);
        result = 31 * result + Objects.hashCode(this.path);
        result = 31 * result + Objects.hashCode(this.size);
        result = 31 * result + Objects.hashCode(this.modificationTime);
        result = 31 * result + Objects.hashCode(this.visibility.toString());
        result = 31 * result + Objects.hashCode(this.resourceType.toString());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == YarnLocalResourceDescriptor.class) {
            YarnLocalResourceDescriptor that = (YarnLocalResourceDescriptor)obj;
            return Objects.equals(this.resourceKey, that.resourceKey) && Objects.equals(this.path, that.path) && Objects.equals(this.size, that.size) && Objects.equals(this.modificationTime, that.modificationTime) && Objects.equals(this.visibility, that.visibility) && Objects.equals(this.resourceType, that.resourceType);
        }
        return false;
    }

    public LocalResource toLocalResource() {
        return Utils.registerLocalResource(this.path, this.size, this.modificationTime, this.visibility, this.resourceType);
    }
}

