/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.yarn;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.Container;
import org.slf4j.Logger;

class RegisterApplicationMasterResponseReflector {
    private final Logger logger;
    private Optional<Method> getContainersFromPreviousAttemptsMethod;
    private Optional<Method> getSchedulerResourceTypesMethod;

    RegisterApplicationMasterResponseReflector(Logger log) {
        this(log, RegisterApplicationMasterResponse.class);
    }

    @VisibleForTesting
    RegisterApplicationMasterResponseReflector(Logger log, Class<?> clazz) {
        this.logger = Objects.requireNonNull(log);
        Objects.requireNonNull(clazz);
        this.getContainersFromPreviousAttemptsMethod = this.tryGetMethod(clazz, "getContainersFromPreviousAttempts", "Cannot reconnect to previously allocated containers");
        this.getSchedulerResourceTypesMethod = this.tryGetMethod(clazz, "getSchedulerResourceTypes", "Cannot get scheduler resource types");
    }

    private Optional<Method> tryGetMethod(Class<?> clazz, String methodName, String noMethodMessage) {
        try {
            return Optional.of(clazz.getMethod(methodName, new Class[0]));
        }
        catch (NoSuchMethodException e) {
            this.logger.info("{}: This YARN version does not support '{}'", (Object)noMethodMessage, (Object)methodName);
            return Optional.empty();
        }
    }

    List<Container> getContainersFromPreviousAttempts(RegisterApplicationMasterResponse response) {
        return this.getContainersFromPreviousAttemptsUnsafe(response);
    }

    @VisibleForTesting
    List<Container> getContainersFromPreviousAttemptsUnsafe(Object response) {
        if (this.getContainersFromPreviousAttemptsMethod.isPresent() && response != null) {
            try {
                List containers = (List)this.getContainersFromPreviousAttemptsMethod.get().invoke(response, new Object[0]);
                if (containers != null && !containers.isEmpty()) {
                    return containers;
                }
            }
            catch (Exception t) {
                this.logger.error("Error invoking 'getContainersFromPreviousAttempts()'", (Throwable)t);
            }
        }
        return Collections.emptyList();
    }

    @VisibleForTesting
    Optional<Method> getGetContainersFromPreviousAttemptsMethod() {
        return this.getContainersFromPreviousAttemptsMethod;
    }

    Optional<Set<String>> getSchedulerResourceTypeNames(RegisterApplicationMasterResponse response) {
        return this.getSchedulerResourceTypeNamesUnsafe(response);
    }

    @VisibleForTesting
    Optional<Set<String>> getSchedulerResourceTypeNamesUnsafe(Object response) {
        if (this.getSchedulerResourceTypesMethod.isPresent() && response != null) {
            try {
                Set schedulerResourceTypes = (Set)this.getSchedulerResourceTypesMethod.get().invoke(response, new Object[0]);
                return Optional.of(((Set)Preconditions.checkNotNull((Object)schedulerResourceTypes)).stream().map(Enum::name).collect(Collectors.toSet()));
            }
            catch (Exception e) {
                this.logger.error("Error invoking 'getSchedulerResourceTypes()'", (Throwable)e);
            }
        }
        return Optional.empty();
    }

    @VisibleForTesting
    Optional<Method> getGetSchedulerResourceTypesMethod() {
        return this.getSchedulerResourceTypesMethod;
    }
}

