/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.yarn;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.util.StringUtils;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ContainerRequestReflector {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerRequestReflector.class);
    static final ContainerRequestReflector INSTANCE = new ContainerRequestReflector();
    @Nullable
    private Constructor<? extends AMRMClient.ContainerRequest> defaultConstructor;

    private ContainerRequestReflector() {
        this(AMRMClient.ContainerRequest.class);
    }

    @VisibleForTesting
    ContainerRequestReflector(Class<? extends AMRMClient.ContainerRequest> containerRequestClass) {
        Class<? extends AMRMClient.ContainerRequest> requestCls = containerRequestClass;
        try {
            this.defaultConstructor = requestCls.getDeclaredConstructor(Resource.class, String[].class, String[].class, Priority.class, Boolean.TYPE, String.class);
        }
        catch (NoSuchMethodException exception) {
            LOG.debug("The node-label mechanism of Yarn don't be supported in this Hadoop version.");
        }
    }

    public AMRMClient.ContainerRequest getContainerRequest(Resource containerResource, Priority priority, String nodeLabel) {
        if (StringUtils.isNullOrWhitespaceOnly((String)nodeLabel) || this.defaultConstructor == null) {
            return new AMRMClient.ContainerRequest(containerResource, null, null, priority);
        }
        try {
            return this.defaultConstructor.newInstance(containerResource, null, null, priority, true, nodeLabel);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            LOG.warn("Errors on creating Container Request.", (Throwable)e);
            return new AMRMClient.ContainerRequest(containerResource, null, null, priority);
        }
    }
}

