/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import org.apache.flink.util.OperatingSystem;

public class ShellScript {
    public static ShellScriptBuilder createShellScriptBuilder() {
        if (OperatingSystem.isWindows()) {
            return new WindowsShellScriptBuilder();
        }
        return new UnixShellScriptBuilder();
    }

    public static String getScriptExtension() {
        return OperatingSystem.isWindows() ? ".cmd" : ".sh";
    }

    private static final class WindowsShellScriptBuilder
    extends ShellScriptBuilder {
        WindowsShellScriptBuilder() {
            this.line("@setlocal");
            this.line(new String[0]);
        }

        @Override
        public void command(List<String> command) {
            this.line("@call ", String.join((CharSequence)" ", command));
        }

        @Override
        public void env(String key, String value) {
            this.line("@set ", key, "=", value);
        }
    }

    private static final class UnixShellScriptBuilder
    extends ShellScriptBuilder {
        UnixShellScriptBuilder() {
            this.line("#!/usr/bin/env bash");
            this.line(new String[0]);
        }

        @Override
        public void command(List<String> command) {
            this.line("exec ", String.join((CharSequence)" ", command));
        }

        @Override
        public void env(String key, String value) {
            this.line("export ", key, "=\"", value, "\"");
        }
    }

    public static abstract class ShellScriptBuilder {
        private static final String LINE_SEPARATOR = System.getProperty("line.separator");
        private final StringBuilder sb = new StringBuilder();

        void line(String ... command) {
            for (String s : command) {
                this.sb.append(s);
            }
            this.sb.append(LINE_SEPARATOR);
        }

        public void write(File file) throws IOException {
            try (FileWriter fwrt = new FileWriter(file);
                 PrintWriter out = new PrintWriter(fwrt);){
                out.append(this.sb);
            }
            file.setExecutable(true, false);
        }

        public abstract void command(List<String> var1);

        public abstract void env(String var1, String var2);
    }
}

