/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.testdata;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.List;
import java.util.Random;
import java.util.regex.Pattern;
import org.apache.flink.api.java.tuple.Tuple2;
import org.junit.Assert;

public class ConnectedComponentsData {
    public static final String getEnumeratingVertices(int num) {
        if (num < 1 || num > 1000000) {
            throw new IllegalArgumentException();
        }
        StringBuilder bld = new StringBuilder(3 * num);
        for (int i = 1; i <= num; ++i) {
            bld.append(i);
            bld.append('\n');
        }
        return bld.toString();
    }

    public static final String getRandomOddEvenEdges(int numEdges, int numVertices, long seed) {
        if (numVertices < 2 || numVertices > 1000000 || numEdges < numVertices || numEdges > 1000000) {
            throw new IllegalArgumentException();
        }
        StringBuilder bld = new StringBuilder(5 * numEdges);
        for (int i = 3; i <= numVertices; ++i) {
            bld.append(i - 2).append(' ').append(i).append('\n');
        }
        numEdges -= numVertices - 2;
        Random r = new Random(seed);
        for (int i = 1; i <= numEdges; ++i) {
            int target;
            int evenOdd = r.nextBoolean() ? 1 : 0;
            int source = r.nextInt(numVertices) + 1;
            if (source % 2 != evenOdd && --source < 1) {
                source = 2;
            }
            if ((target = r.nextInt(numVertices) + 1) % 2 != evenOdd && --target < 1) {
                target = 2;
            }
            bld.append(source).append(' ').append(target).append('\n');
        }
        return bld.toString();
    }

    public static void checkOddEvenResult(BufferedReader result) throws IOException {
        String line;
        Pattern split = Pattern.compile(" ");
        while ((line = result.readLine()) != null) {
            String[] res = split.split(line);
            Assert.assertEquals((String)"Malformed result: Wrong number of tokens in line.", (long)2L, (long)res.length);
            try {
                int vertex = Integer.parseInt(res[0]);
                int component = Integer.parseInt(res[1]);
                int should = vertex % 2;
                if (should == 0) {
                    should = 2;
                }
                Assert.assertEquals((String)"Vertex is in wrong component.", (long)should, (long)component);
            }
            catch (NumberFormatException e) {
                Assert.fail((String)"Malformed result.");
            }
        }
    }

    public static void checkOddEvenResult(List<Tuple2<Long, Long>> lines) throws IOException {
        for (Tuple2<Long, Long> line : lines) {
            try {
                long vertex = (Long)line.f0;
                long component = (Long)line.f1;
                long should = vertex % 2L;
                if (should == 0L) {
                    should = 2L;
                }
                Assert.assertEquals((String)"Vertex is in wrong component.", (long)should, (long)component);
            }
            catch (NumberFormatException e) {
                Assert.fail((String)"Malformed result.");
            }
        }
    }

    private ConnectedComponentsData() {
    }
}

