/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import javax.annotation.Nullable;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class TestNameProvider
implements TestRule {
    private static ThreadLocal<String> testName = new ThreadLocal();

    @Nullable
    public static String getCurrentTestName() {
        return testName.get();
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                testName.set(description.getDisplayName());
                try {
                    base.evaluate();
                }
                finally {
                    testName.set(null);
                }
            }
        };
    }
}

