/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.testutils.junit.extensions;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.rules.TemporaryFolder;

public class ContextClassLoaderExtension
implements BeforeAllCallback,
AfterAllCallback {
    private final TemporaryFolder temporaryFolder = new TemporaryFolder();
    private final Function<TemporaryFolder, URLClassLoader> temporaryClassLoaderFactory;
    private ClassLoader originalClassLoader;
    private URLClassLoader temporaryClassLoader;

    private ContextClassLoaderExtension(Function<TemporaryFolder, URLClassLoader> temporaryClassLoaderFactory) {
        this.temporaryClassLoaderFactory = temporaryClassLoaderFactory;
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        this.temporaryFolder.create();
        this.originalClassLoader = Thread.currentThread().getContextClassLoader();
        this.temporaryClassLoader = this.temporaryClassLoaderFactory.apply(this.temporaryFolder);
        Thread.currentThread().setContextClassLoader(this.temporaryClassLoader);
    }

    public void afterAll(ExtensionContext context) throws Exception {
        Thread.currentThread().setContextClassLoader(this.originalClassLoader);
        this.temporaryClassLoader.close();
        this.temporaryFolder.delete();
    }

    public static ContextClassLoaderExtensionBuilder builder() {
        return new ContextClassLoaderExtensionBuilder();
    }

    private static URLClassLoader setupClassLoader(TemporaryFolder temporaryFolder, Collection<ServiceEntry> serviceEntries) {
        Path root = temporaryFolder.getRoot().toPath();
        try {
            ContextClassLoaderExtension.writeServiceEntries(root, serviceEntries);
            URL url = temporaryFolder.getRoot().toURI().toURL();
            return new URLClassLoader(new URL[]{url}, ContextClassLoaderExtension.class.getClassLoader());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void writeServiceEntries(Path tmpDir, Collection<ServiceEntry> serviceEntries) throws IOException {
        for (ServiceEntry serviceEntry : serviceEntries) {
            Path path = tmpDir.resolve(Paths.get("META-INF", "services", serviceEntry.serviceClass.getCanonicalName()));
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.write(path, serviceEntry.serviceImplementations, StandardOpenOption.CREATE);
        }
    }

    private static class ServiceEntry {
        private final Class<?> serviceClass;
        private final List<String> serviceImplementations;

        public ServiceEntry(Class<?> serviceClass, String ... serviceImplementations) {
            this.serviceClass = serviceClass;
            this.serviceImplementations = Arrays.asList(serviceImplementations);
        }
    }

    public static class ContextClassLoaderExtensionBuilder {
        private final Collection<ServiceEntry> serviceEntries = new ArrayList<ServiceEntry>();

        public ContextClassLoaderExtensionBuilder withServiceEntry(Class<?> serviceClass, String ... serviceImplementations) {
            this.serviceEntries.add(new ServiceEntry(serviceClass, serviceImplementations));
            return this;
        }

        public ContextClassLoaderExtension build() {
            Function<TemporaryFolder, URLClassLoader> factory = temporaryFolder -> ContextClassLoaderExtension.setupClassLoader(temporaryFolder, this.serviceEntries);
            return new ContextClassLoaderExtension(factory);
        }

        private ContextClassLoaderExtensionBuilder() {
        }
    }
}

