/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.testutils.junit;

import javax.annotation.Nullable;
import org.apache.flink.testutils.junit.RetryOnException;
import org.apache.flink.testutils.junit.RetryOnFailure;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryRule
implements TestRule {
    public static final Logger LOG = LoggerFactory.getLogger(RetryRule.class);

    public Statement apply(Statement statement, Description description) {
        RetryOnFailure retryOnFailure = (RetryOnFailure)description.getAnnotation(RetryOnFailure.class);
        RetryOnException retryOnException = (RetryOnException)description.getAnnotation(RetryOnException.class);
        if (retryOnFailure == null && retryOnException == null) {
            retryOnFailure = description.getTestClass().getAnnotation(RetryOnFailure.class);
            retryOnException = description.getTestClass().getAnnotation(RetryOnException.class);
        }
        if (retryOnFailure != null && retryOnException != null) {
            throw new IllegalArgumentException("You cannot combine the RetryOnFailure and RetryOnException annotations.");
        }
        Class<? extends Throwable> whitelistedException = RetryRule.getExpectedException(description);
        if (retryOnFailure != null) {
            return new RetryOnFailureStatement(retryOnFailure.times(), statement, whitelistedException);
        }
        if (retryOnException != null) {
            return new RetryOnExceptionStatement(retryOnException.times(), retryOnException.exception(), statement, whitelistedException);
        }
        return statement;
    }

    @Nullable
    private static Class<? extends Throwable> getExpectedException(Description description) {
        Test test = (Test)description.getAnnotation(Test.class);
        if (test.expected() != Test.None.class) {
            return test.expected();
        }
        return null;
    }

    private static class RetryOnExceptionStatement
    extends Statement {
        private final Class<? extends Throwable> exceptionClass;
        private final int timesOnFailure;
        private final Statement statement;
        @Nullable
        private final Class<? extends Throwable> expectedException;

        private RetryOnExceptionStatement(int timesOnFailure, Class<? extends Throwable> exceptionClass, Statement statement, @Nullable Class<? extends Throwable> expectedException) {
            if (timesOnFailure < 0) {
                throw new IllegalArgumentException("Negatives number of retries on failure");
            }
            if (exceptionClass == null) {
                throw new NullPointerException("exceptionClass");
            }
            this.exceptionClass = exceptionClass;
            this.timesOnFailure = timesOnFailure;
            this.statement = statement;
            this.expectedException = expectedException;
        }

        public void evaluate() throws Throwable {
            for (int currentRun = 0; currentRun <= this.timesOnFailure; ++currentRun) {
                try {
                    this.statement.evaluate();
                    break;
                }
                catch (Throwable t) {
                    if (this.expectedException != null && this.expectedException.isAssignableFrom(t.getClass())) {
                        throw t;
                    }
                    LOG.warn(String.format("Test run failed (%d/%d).", currentRun, this.timesOnFailure + 1), t);
                    if (this.exceptionClass.isAssignableFrom(t.getClass()) && currentRun < this.timesOnFailure) continue;
                    throw t;
                }
            }
        }
    }

    private static class RetryOnFailureStatement
    extends Statement {
        private final int timesOnFailure;
        private final Statement statement;
        @Nullable
        private final Class<? extends Throwable> expectedException;

        private RetryOnFailureStatement(int timesOnFailure, Statement statement, @Nullable Class<? extends Throwable> expectedException) {
            this.expectedException = expectedException;
            if (timesOnFailure < 0) {
                throw new IllegalArgumentException("Negatives number of retries on failure");
            }
            this.timesOnFailure = timesOnFailure;
            this.statement = statement;
        }

        public void evaluate() throws Throwable {
            for (int currentRun = 0; currentRun <= this.timesOnFailure; ++currentRun) {
                try {
                    this.statement.evaluate();
                    break;
                }
                catch (Throwable t) {
                    if (this.expectedException != null && this.expectedException.isAssignableFrom(t.getClass())) {
                        throw t;
                    }
                    LOG.warn(String.format("Test run failed (%d/%d).", currentRun, this.timesOnFailure + 1), t);
                    if (currentRun != this.timesOnFailure) continue;
                    throw t;
                }
            }
        }
    }
}

