/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.deltajoin;

import java.util.LinkedHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.shaded.guava33.com.google.common.cache.Cache;
import org.apache.flink.shaded.guava33.com.google.common.cache.CacheBuilder;
import org.apache.flink.shaded.guava33.com.google.common.cache.RemovalListener;
import org.apache.flink.shaded.guava33.com.google.common.cache.RemovalNotification;
import org.apache.flink.table.data.RowData;
import org.apache.flink.util.Preconditions;

@NotThreadSafe
public class DeltaJoinCache {
    private static final String LEFT_CACHE_METRIC_PREFIX = "deltaJoin.leftCache.";
    private static final String RIGHT_CACHE_METRIC_PREFIX = "deltaJoin.rightCache.";
    private static final String METRIC_HIT_RATE = "hitRate";
    private static final String METRIC_REQUEST_COUNT = "requestCount";
    private static final String METRIC_HIT_COUNT = "hitCount";
    private static final String METRIC_KEY_SIZE = "keySize";
    private static final String METRIC_TOTAL_NON_EMPTY_VALUE_SIZE = "totalNonEmptyValues";
    private final Cache<RowData, LinkedHashMap<RowData, Object>> leftCache;
    private final Cache<RowData, LinkedHashMap<RowData, Object>> rightCache;
    private final AtomicLong leftTotalSize = new AtomicLong(0L);
    private final AtomicLong rightTotalSize = new AtomicLong(0L);
    private final AtomicLong leftHitCount = new AtomicLong(0L);
    private final AtomicLong leftRequestCount = new AtomicLong(0L);
    private final AtomicLong rightHitCount = new AtomicLong(0L);
    private final AtomicLong rightRequestCount = new AtomicLong(0L);

    public DeltaJoinCache(long leftCacheMaxSize, long rightCacheMaxSize) {
        this.leftCache = CacheBuilder.newBuilder().maximumSize(leftCacheMaxSize).removalListener((RemovalListener)new DeltaJoinCacheRemovalListener(true)).build();
        this.rightCache = CacheBuilder.newBuilder().maximumSize(rightCacheMaxSize).removalListener((RemovalListener)new DeltaJoinCacheRemovalListener(false)).build();
    }

    public void registerMetrics(MetricGroup metricGroup) {
        metricGroup.gauge("deltaJoin.leftCache.hitRate", () -> this.leftRequestCount.get() == 0L ? 0.0 : Long.valueOf(this.leftHitCount.get()).doubleValue() / (double)this.leftRequestCount.get());
        metricGroup.gauge("deltaJoin.leftCache.requestCount", this.rightRequestCount::get);
        metricGroup.gauge("deltaJoin.leftCache.hitCount", this.leftHitCount::get);
        metricGroup.gauge("deltaJoin.leftCache.keySize", () -> this.leftCache.size());
        metricGroup.gauge("deltaJoin.leftCache.totalNonEmptyValues", this.leftTotalSize::get);
        metricGroup.gauge("deltaJoin.rightCache.hitRate", () -> this.rightRequestCount.get() == 0L ? 0.0 : Long.valueOf(this.rightHitCount.get()).doubleValue() / (double)this.rightRequestCount.get());
        metricGroup.gauge("deltaJoin.rightCache.requestCount", this.rightRequestCount::get);
        metricGroup.gauge("deltaJoin.rightCache.hitCount", this.rightHitCount::get);
        metricGroup.gauge("deltaJoin.rightCache.keySize", () -> this.rightCache.size());
        metricGroup.gauge("deltaJoin.rightCache.totalNonEmptyValues", this.rightTotalSize::get);
    }

    @Nullable
    public LinkedHashMap<RowData, Object> getData(RowData key, boolean requestRightCache) {
        return requestRightCache ? (LinkedHashMap)this.rightCache.getIfPresent((Object)key) : (LinkedHashMap)this.leftCache.getIfPresent((Object)key);
    }

    public void buildCache(RowData key, LinkedHashMap<RowData, Object> ukDataMap, boolean buildRightCache) {
        Preconditions.checkState((this.getData(key, buildRightCache) == null ? 1 : 0) != 0);
        if (buildRightCache) {
            this.rightCache.put((Object)key, ukDataMap);
            this.rightTotalSize.addAndGet(ukDataMap.size());
        } else {
            this.leftCache.put((Object)key, ukDataMap);
            this.leftTotalSize.addAndGet(ukDataMap.size());
        }
    }

    public void upsertCache(RowData key, RowData uk, Object data, boolean upsertRightCache) {
        if (upsertRightCache) {
            this.upsert(this.rightCache, key, uk, data, this.rightTotalSize);
        } else {
            this.upsert(this.leftCache, key, uk, data, this.leftTotalSize);
        }
    }

    private void upsert(Cache<RowData, LinkedHashMap<RowData, Object>> cache, RowData key, RowData uk, Object data, AtomicLong cacheTotalSize) {
        cache.asMap().computeIfPresent(key, (k, v) -> {
            Object oldData = v.put(uk, data);
            if (oldData == null) {
                cacheTotalSize.incrementAndGet();
            }
            return v;
        });
    }

    public void requestLeftCache() {
        this.leftRequestCount.incrementAndGet();
    }

    public void requestRightCache() {
        this.rightRequestCount.incrementAndGet();
    }

    public void hitLeftCache() {
        this.leftHitCount.incrementAndGet();
    }

    public void hitRightCache() {
        this.rightHitCount.incrementAndGet();
    }

    @VisibleForTesting
    public Cache<RowData, LinkedHashMap<RowData, Object>> getLeftCache() {
        return this.leftCache;
    }

    @VisibleForTesting
    public Cache<RowData, LinkedHashMap<RowData, Object>> getRightCache() {
        return this.rightCache;
    }

    @VisibleForTesting
    public AtomicLong getLeftTotalSize() {
        return this.leftTotalSize;
    }

    @VisibleForTesting
    public AtomicLong getRightTotalSize() {
        return this.rightTotalSize;
    }

    @VisibleForTesting
    public AtomicLong getLeftHitCount() {
        return this.leftHitCount;
    }

    @VisibleForTesting
    public AtomicLong getLeftRequestCount() {
        return this.leftRequestCount;
    }

    @VisibleForTesting
    public AtomicLong getRightHitCount() {
        return this.rightHitCount;
    }

    @VisibleForTesting
    public AtomicLong getRightRequestCount() {
        return this.rightRequestCount;
    }

    private class DeltaJoinCacheRemovalListener
    implements RemovalListener<RowData, LinkedHashMap<RowData, Object>> {
        private final boolean isLeftCache;

        public DeltaJoinCacheRemovalListener(boolean isLeftCache) {
            this.isLeftCache = isLeftCache;
        }

        public void onRemoval(RemovalNotification<RowData, LinkedHashMap<RowData, Object>> removalNotification) {
            if (removalNotification.getValue() == null) {
                return;
            }
            if (this.isLeftCache) {
                DeltaJoinCache.this.leftTotalSize.addAndGet(-((LinkedHashMap)removalNotification.getValue()).size());
            } else {
                DeltaJoinCache.this.rightTotalSize.addAndGet(-((LinkedHashMap)removalNotification.getValue()).size());
            }
        }
    }
}

