/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.over;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.generated.GeneratedAggsHandleFunction;
import org.apache.flink.table.runtime.generated.GeneratedRecordComparator;
import org.apache.flink.table.runtime.generated.GeneratedRecordEqualiser;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.operators.over.AbstractNonTimeUnboundedPrecedingOver;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Collector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonTimeRangeUnboundedPrecedingFunction<K>
extends AbstractNonTimeUnboundedPrecedingOver<K> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(NonTimeRangeUnboundedPrecedingFunction.class);

    public NonTimeRangeUnboundedPrecedingFunction(long stateRetentionTime, GeneratedAggsHandleFunction genAggsHandler, GeneratedRecordEqualiser genRecordEqualiser, GeneratedRecordEqualiser genSortKeyEqualiser, GeneratedRecordComparator genSortKeyComparator, LogicalType[] accTypes, LogicalType[] inputFieldTypes, LogicalType[] sortKeyTypes, RowDataKeySelector sortKeySelector) {
        super(stateRetentionTime, genAggsHandler, genRecordEqualiser, genSortKeyEqualiser, genSortKeyComparator, accTypes, inputFieldTypes, sortKeyTypes, sortKeySelector, InternalTypeInfo.ofFields(sortKeyTypes));
    }

    @Override
    void insertIntoSortedList(RowData insRow, Collector<RowData> out) throws Exception {
        Long id = this.getNextId();
        List<Tuple2<RowData, List<Long>>> sortedList = this.getSortedList();
        RowKind origRowKind = insRow.getRowKind();
        insRow.setRowKind(RowKind.INSERT);
        RowData inputSortKey = (RowData)this.sortKeySelector.getKey((Object)insRow);
        Tuple2<Integer, Boolean> indexForInsertOrUpdate = this.findIndexOfSortKey(sortedList, inputSortKey, false);
        boolean isInsert = (Boolean)indexForInsertOrUpdate.f1;
        int index = (Integer)indexForInsertOrUpdate.f0;
        if (isInsert) {
            if (index == -1) {
                sortedList.add((Tuple2<RowData, List<Long>>)new Tuple2((Object)inputSortKey, List.of(id)));
                index = sortedList.size() - 1;
            } else {
                sortedList.add(index, (Tuple2<RowData, List<Long>>)new Tuple2((Object)inputSortKey, List.of(id)));
            }
            this.setAccumulatorOfPrevRow(sortedList, index - 1);
            this.aggFuncs.accumulate(insRow);
            this.collectInsertOrUpdateAfter(out, insRow, origRowKind, this.aggFuncs.getValue());
        } else {
            ArrayList<Long> ids = new ArrayList<Long>((Collection)sortedList.get((int)index).f1);
            ids.add(id);
            sortedList.set(index, (Tuple2<RowData, List<Long>>)new Tuple2((Object)inputSortKey, ids));
            this.setAccumulatorOfPrevRow(sortedList, index - 1);
            this.reAccumulateIdsAfterInsert(this.aggFuncs.getAccumulators(), ids, insRow);
            this.emitUpdatesForIds(ids, ids.size() - 1, (RowData)this.accMapState.get((Object)inputSortKey), this.aggFuncs.getAccumulators(), origRowKind, insRow, out);
        }
        this.valueMapState.put((Object)id, (Object)insRow);
        this.accMapState.put((Object)inputSortKey, (Object)this.aggFuncs.getAccumulators());
        this.sortedListState.update(sortedList);
        id = id + 1L;
        this.idState.update((Object)id);
        this.processRemainingElements(sortedList, index + 1, this.aggFuncs.getAccumulators(), out);
    }

    private void setAccumulatorOfPrevRow(List<Tuple2<RowData, List<Long>>> sortedList, int prevIndex) throws Exception {
        if (prevIndex < 0) {
            RowData accData = this.aggFuncs.createAccumulators();
            this.aggFuncs.setAccumulators(accData);
        } else {
            RowData prevAcc = (RowData)this.accMapState.get((Object)((RowData)sortedList.get((int)prevIndex).f0));
            if (prevAcc == null) {
                RowData accData = this.aggFuncs.createAccumulators();
                this.aggFuncs.setAccumulators(accData);
            } else {
                this.aggFuncs.setAccumulators(prevAcc);
            }
        }
    }

    @Override
    void reAccumulateIdsAfterInsert(RowData currAcc, List<Long> ids, RowData insRow) throws Exception {
        this.aggFuncs.setAccumulators(currAcc);
        for (int j = 0; j < ids.size() - 1; ++j) {
            RowData value = (RowData)this.valueMapState.get((Object)ids.get(j));
            this.aggFuncs.accumulate(value);
        }
        this.aggFuncs.accumulate(insRow);
    }

    @Override
    void sendUpdatesForIds(List<Long> ids, int idxOfChangedRow, Collector<RowData> out, RowKind rowKind, RowData changedRow, RowData prevAggValue, RowData currAggValue) throws Exception {
        for (int j = 0; j < ids.size(); ++j) {
            if (j == idxOfChangedRow) {
                this.sendUpdateForChangedRow(out, rowKind, changedRow, prevAggValue, currAggValue);
                continue;
            }
            RowData value = (RowData)this.valueMapState.get((Object)ids.get(j));
            this.collectUpdateBefore(out, value, prevAggValue);
            this.collectUpdateAfter(out, value, currAggValue);
        }
    }

    @Override
    void processRemainingElements(List<Tuple2<RowData, List<Long>>> sortedList, int startPos, RowData currAcc, Collector<RowData> out) throws Exception {
        for (int i = startPos; i < sortedList.size(); ++i) {
            Tuple2<RowData, List<Long>> sortKeyAndIds = sortedList.get(i);
            RowData curSortKey = (RowData)sortKeyAndIds.f0;
            List ids = (List)sortKeyAndIds.f1;
            RowData lastValue = null;
            this.aggFuncs.setAccumulators(currAcc);
            for (int j = 0; j < ids.size(); ++j) {
                RowData value = (RowData)this.valueMapState.get((Object)((Long)ids.get(j)));
                this.aggFuncs.accumulate(value);
                lastValue = value;
            }
            currAcc = this.aggFuncs.getAccumulators();
            RowData prevAcc = (RowData)this.accMapState.get((Object)curSortKey);
            if (prevAcc.equals(currAcc)) {
                LOG.debug("Prev accumulator is same as curr accumulator. Skipping further updates.");
                return;
            }
            RowData prevAggValue = this.setAccumulatorAndGetValue(prevAcc);
            RowData currAggValue = this.setAccumulatorAndGetValue(currAcc);
            for (int j = 0; j < ids.size(); ++j) {
                RowData value = ids.size() - 1 == j ? lastValue : (RowData)this.valueMapState.get((Object)((Long)ids.get(j)));
                this.collectUpdateBefore(out, value, prevAggValue);
                this.collectUpdateAfter(out, value, currAggValue);
            }
            this.accMapState.put((Object)curSortKey, (Object)currAcc);
        }
    }

    @Override
    void removeFromSortedList(RowData delRow, Collector<RowData> out) throws Exception {
        delRow.setRowKind(RowKind.INSERT);
        RowData inputSortKey = (RowData)this.sortKeySelector.getKey((Object)delRow);
        List<Tuple2<RowData, List<Long>>> sortedList = this.getSortedList();
        int i = (Integer)this.findIndexOfSortKey(sortedList, (RowData)inputSortKey, (boolean)true).f0;
        if (i == -1) {
            LOG.debug("Could not find matching sort key. Skipping delete.");
            this.numOfSortKeysNotFound.inc();
            return;
        }
        RowData curSortKey = (RowData)sortedList.get((int)i).f0;
        ArrayList<Long> ids = new ArrayList<Long>((Collection)sortedList.get((int)i).f1);
        this.setAccumulatorOfPrevRow(sortedList, i - 1);
        int removeIndex = this.reAccumulateIdsAndGetRemoveIndex(ids, delRow);
        if (removeIndex == -1) {
            LOG.info("Could not find matching row to remove. Missing id from sortKey ids list.");
            this.numOfIdsNotFound.inc();
            return;
        }
        this.emitUpdatesForIds(ids, removeIndex, (RowData)this.accMapState.get((Object)curSortKey), this.aggFuncs.getAccumulators(), RowKind.DELETE, delRow, out);
        Long deletedId = (Long)ids.remove(removeIndex);
        i = this.removeIdFromSortedList(sortedList, i, ids, curSortKey);
        this.valueMapState.remove((Object)deletedId);
        if (ids.isEmpty()) {
            this.accMapState.remove((Object)curSortKey);
        } else {
            this.accMapState.put((Object)curSortKey, (Object)this.aggFuncs.getAccumulators());
        }
        this.sortedListState.update(sortedList);
        this.processRemainingElements(sortedList, i, this.aggFuncs.getAccumulators(), out);
    }

    private int reAccumulateIdsAndGetRemoveIndex(List<Long> ids, RowData delRow) throws Exception {
        int removeIndex = -1;
        for (int j = 0; j < ids.size(); ++j) {
            RowData curValue = (RowData)this.valueMapState.get((Object)ids.get(j));
            if (this.valueEqualiser.equals(curValue, delRow)) {
                removeIndex = j;
                continue;
            }
            this.aggFuncs.accumulate(curValue);
        }
        return removeIndex;
    }
}

